/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.faq.QAPair;
import com.arsdigita.faq.ui.QAView;
import com.arsdigita.faq.util.GlobalizationUtil;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import java.math.BigDecimal;

class AdminQuestionView
extends SimpleContainer {
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/AdminQuestionView.java#5 $$Author: dennis $$DateTime: 2004/08/17 23:26:27 $";
    private RequestLocal m_question;
    private SingleSelectionModel m_selection;
    private ToggleLink m_editLink;

    public AdminQuestionView(final SingleSelectionModel selection) {
        this.m_selection = selection;
        ActionLink returnLink = new ActionLink((String)GlobalizationUtil.globalize("cw.faq.ui.return_to_all_questions").localize());
        returnLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                selection.clearSelection(e.getPageState());
            }
        });
        this.add((Component)returnLink);
        this.m_question = new RequestLocal(){

            protected Object initialValue(PageState s) {
                try {
                    QAPair qa = new QAPair(new BigDecimal((String)selection.getSelectedKey(s)));
                    qa.assertPrivilege(PrivilegeDescriptor.READ);
                    return qa;
                }
                catch (DataObjectNotFoundException e) {
                    return null;
                }
            }
        };
        Label question = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label l = (Label)e.getTarget();
                l.setLabel(AdminQuestionView.this.getQAPair(e.getPageState()).getQuestion());
            }
        });
        Label answer = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label l = (Label)e.getTarget();
                l.setLabel(AdminQuestionView.this.getQAPair(e.getPageState()).getAnswer().getHTMLText());
            }
        });
        this.add((Component)new QAView(question, answer));
        ListPanel linkList = new ListPanel(false);
        this.m_editLink = new ToggleLink("Edit this question");
        linkList.add((Component)this.m_editLink);
        ActionLink deleteLink = new ActionLink((String)GlobalizationUtil.globalize("cw.faq.ui.delete_this_question").localize());
        deleteLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                final QAPair pair = AdminQuestionView.this.getQAPair(state);
                if (pair != null) {
                    KernelExcursion ex = new KernelExcursion(){

                        protected void excurse() {
                            this.setEffectiveParty(Kernel.getSystemParty());
                            pair.delete();
                        }
                    };
                    ex.run();
                }
                selection.clearSelection(state);
            }
        });
        deleteLink.setConfirmation("This will permanently delete the question. Do you want to do this?");
        linkList.add((Component)deleteLink);
        this.add((Component)linkList);
    }

    ToggleLink getEditLink() {
        return this.m_editLink;
    }

    private QAPair getQAPair(PageState state) {
        return (QAPair)((Object)this.m_question.get(state));
    }
}

