/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks;

import com.arsdigita.bookmarks.Bookmark;
import com.arsdigita.bookmarks.BookmarkCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Bookmarks
extends Application {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.BookmarkApplication";
    private static final int SORT_KEY_JUMP = 10;
    private static final Logger log = Logger.getLogger(Bookmarks.class);

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Bookmarks(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Bookmarks(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)key));
    }

    public Bookmarks(DataObject dataObject) {
        super(dataObject);
    }

    public static Bookmarks create(String urlName, String title, Application parent) {
        return (Bookmarks)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
    }

    public Bookmark createBookmark(String name, String URLString) {
        Bookmark bmrk = new Bookmark(name, URLString);
        bmrk.setBookmarkApplication(this);
        return bmrk;
    }

    public void removeBookmark(Bookmark bmrk) {
        this.remove("bookmarks", (DomainObject)bmrk);
    }

    public BookmarkCollection getBookmarks() {
        DataAssociation bmrksdata = (DataAssociation)this.get("bookmarks");
        BookmarkCollection bmrks = new BookmarkCollection(bmrksdata.getDataCollection());
        bmrks.addOrder("sortKey");
        return bmrks;
    }

    public void swapBookmarkWithPrevious(Bookmark b) throws PersistenceException {
        int newKey = b.getSortKey() - 11;
        b.setSortKey(newKey);
        b.save();
        this.normalizeBookmarkSortKeys();
    }

    public void swapBookmarkWithNext(Bookmark b) throws PersistenceException {
        int newKey = b.getSortKey() + 11;
        b.setSortKey(newKey);
        b.save();
        this.normalizeBookmarkSortKeys();
    }

    public void normalizeBookmarkSortKeys() {
        BookmarkCollection bColl = this.getBookmarks();
        int index = 10;
        while (bColl.next()) {
            Bookmark b = bColl.getBookmark();
            b.setSortKey(index);
            b.save();
            index += 10;
        }
    }

    public String getServletPath() {
        return "/bookmarks/";
    }
}

