/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.exporter;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.exporter.DomainObjectExporter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

public class ContentExporter {
    private static final Logger s_log = Logger.getLogger(ContentExporter.class);
    private Map m_folders;
    private Map m_elements;
    private Map m_paths;
    private List m_items;
    private File m_itemDir;
    private File m_assetDir;

    public ContentExporter(File itemDir, File assetDir) {
        this.m_itemDir = itemDir;
        this.m_assetDir = assetDir;
        this.m_folders = new HashMap();
        this.m_elements = new HashMap();
        this.m_paths = new HashMap();
        this.m_items = new ArrayList();
    }

    public void exportManifest(ContentSection section, String version, String systemID) {
        String path;
        Session session = SessionManager.getSession();
        if (!this.m_itemDir.exists() && !this.m_itemDir.mkdirs()) {
            throw new UncheckedWrapperException((Throwable)new IOException("mkdirs " + this.m_itemDir + " failed"));
        }
        DataCollection folders = session.retrieve("com.arsdigita.cms.Folder");
        Filter f = folders.addInSubqueryFilter("id", "com.arsdigita.london.exporter.itemIDsInSection");
        f.set("sectionID", (Object)section.getID());
        folders.addEqualsFilter("isDeleted", (Object)Boolean.FALSE);
        folders.addEqualsFilter("version", (Object)version);
        folders.addOrder("ancestors");
        Element root = null;
        while (folders.next()) {
            Folder folder = (Folder)DomainObjectFactory.newInstance((DataObject)folders.getDataObject());
            Folder parent = this.getParent((ContentItem)folder);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Folder" + folder.getOID() + " parent " + (parent == null ? null : parent.getOID())));
            }
            if (parent != null || folder.getName().equals("/")) {
                Element pel = null;
                if (parent != null) {
                    pel = (Element)this.m_elements.get(parent);
                }
                s_log.debug((Object)("Processing " + folder + " " + pel));
                if (pel == null && parent != null) {
                    s_log.debug((Object)("Oh damn " + folder.getOID()));
                    throw new RuntimeException("No elemnent for " + parent.getOID());
                }
                Element el = new Element("cms:folder", "http://www.arsdigita.com/cms/1.0");
                el.addAttribute("name", folder.getName());
                el.addAttribute("label", folder.getLabel());
                el.addAttribute("oid", folder.getOID().toString());
                this.m_elements.put(folder, el);
                path = parent == null ? "" : this.m_paths.get(parent) + "/" + folder.getName();
                this.m_paths.put(folder, path);
                File dir = new File(this.m_itemDir, path);
                if (!dir.exists() && !dir.mkdir()) {
                    throw new UncheckedWrapperException((Throwable)new IOException("mkdir " + dir + " failed"));
                }
                if (pel != null) {
                    s_log.debug((Object)("Adding " + el + " to " + pel));
                    pel.addContent(el);
                    continue;
                }
                if (root != null) continue;
                s_log.debug((Object)("Is root folder: " + el));
                root = el;
                continue;
            }
            s_log.warn((Object)("Skip " + folder.getOID() + " " + folder.getName()));
        }
        DataCollection items = session.retrieve("com.arsdigita.cms.ContentPage");
        items.addEqualsFilter("isDeleted", (Object)Boolean.FALSE);
        items.addEqualsFilter("version", (Object)version);
        items.addOrder("ancestors");
        while (items.next()) {
            ContentPage item = (ContentPage)DomainObjectFactory.newInstance((DataObject)items.getDataObject());
            if (item.getObjectType().getQualifiedName().equals("com.arsdigita.london.cms.freeform.FreeformContentItem")) continue;
            Folder parent = this.getParent((ContentItem)item);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Item" + item.getOID() + " parent " + (parent == null ? null : parent.getOID())));
            }
            if (parent == null) {
                s_log.warn((Object)("Skipping item " + item.getOID() + " has no parent"));
                continue;
            }
            Element pel = (Element)this.m_elements.get(parent);
            if (pel == null) {
                throw new RuntimeException("No elemnent for " + parent.getOID());
            }
            path = this.m_paths.get(parent) + "/" + item.getName() + ".xml";
            this.m_paths.put(item, path);
            Element el = new Element("cms:external", "http://www.arsdigita.com/cms/1.0");
            el.addAttribute("source", path);
            pel.addContent(el);
            s_log.debug((Object)("Adding " + el + " to " + pel + " path"));
            this.m_items.add(item.getOID());
        }
        Document doc = null;
        try {
            s_log.debug((Object)("Got root " + root));
            Element imp = new Element("imp:import", "http://xmlns.redhat.com/waf/london/importer/1.0");
            imp.addAttribute("source", systemID);
            imp.addContent(root);
            doc = new Document(imp);
        }
        catch (ParserConfigurationException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        try {
            File dst = new File(this.m_itemDir, "index.xml");
            FileOutputStream os = new FileOutputStream(dst, false);
            os.write(doc.toString(true).getBytes("UTF-8"));
            os.flush();
            os.close();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot write file", (Throwable)ex);
        }
    }

    public void exportItems() {
        Iterator oids = this.m_items.iterator();
        while (oids.hasNext()) {
            TransactionContext txn = SessionManager.getSession().getTransactionContext();
            txn.beginTxn();
            OID oid = (OID)oids.next();
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Exporting item " + oid));
            }
            ContentPage item = null;
            try {
                item = (ContentPage)DomainObjectFactory.newInstance((OID)oid);
            }
            catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find item " + oid, (Throwable)ex);
            }
            Element el = new Element("cms:item", "http://www.arsdigita.com/cms/1.0");
            DomainObjectExporter exporter = new DomainObjectExporter(el, this.m_assetDir);
            exporter.setNamespace("cms", "http://www.arsdigita.com/cms/1.0");
            exporter.setWrapAttributes(true);
            exporter.setWrapRoot(false);
            exporter.setWrapObjects(false);
            exporter.walk((DomainObject)item, this.getClass().getName());
            Document doc = null;
            try {
                doc = new Document(el);
            }
            catch (ParserConfigurationException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            try {
                String path = (String)this.m_paths.get(item);
                File dst = new File(this.m_itemDir, "." + path);
                FileOutputStream os = new FileOutputStream(dst);
                os.write(doc.toString(true).getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot write file", (Throwable)ex);
            }
            txn.commitTxn();
        }
    }

    protected Folder getParent(ContentItem item) {
        if (item instanceof Folder) {
            this.m_folders.put(item.get("ancestors"), item);
        }
        String ancestors = (String)item.get("ancestors");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Ancestors " + ancestors));
        }
        String base = null;
        if (item instanceof Folder) {
            base = this.getParentPath(ancestors);
        } else {
            String bundle = this.getParentPath(ancestors);
            String string = base = bundle == null ? null : this.getParentPath(bundle);
        }
        if (base == null) {
            return null;
        }
        Folder parent = (Folder)this.m_folders.get(base);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Item " + item.getOID() + " with " + ancestors + " parent " + base + " obj " + parent));
        }
        return parent;
    }

    protected String getParentPath(String path) {
        int offset = path.lastIndexOf("/", path.length() - 2);
        if (offset == -1) {
            s_log.warn((Object)("No ancestors parent for " + path));
            return null;
        }
        return path.substring(0, offset + 1);
    }
}

