--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- This library is free software; you can redistribute it and/or
-- modify it under the terms of the GNU Lesser General Public License
-- as published by the Free Software Foundation; either version 2.1 of
-- the License, or (at your option) any later version.
--
-- This library is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- Lesser General Public License for more details.
--
-- You should have received a copy of the GNU Lesser General Public
-- License along with this library; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
--
-- $Id: drop-ri-triggers.sql 287 2005-02-22 00:29:02Z sskracic $
-- $DateTime: 2004/08/17 23:15:09 $

delete from pg_trigger
 where tgname in (select tgname
                    from pg_trigger,
                         pg_class a,
                         pg_class b
                   where tgisconstraint
                     and tgconstrrelid = a.oid
                     and tgrelid = b.oid
                     and a.relname in ('acs_auditing',
                                       'acs_object_lifecycle_map',
                                       'acs_objects',
                                       'acs_permissions',
                                       'acs_privileges',
                                       'acs_stylesheet_node_map',
                                       'acs_stylesheet_type_map',
                                       'acs_stylesheets',
                                       'apm_listeners',
                                       'apm_package_type_listener_map',
                                       'apm_package_types',
                                       'apm_packages',
                                       'application_type_privilege_map',
                                       'application_types',
                                       'applications',
                                       'authoring_kit_step_map',
                                       'authoring_kits',
                                       'authoring_steps',
                                       'bebop_component_hierarchy',
                                       'bebop_components',
                                       'bebop_form_process_listeners',
                                       'bebop_form_sections',
                                       'bebop_listener_map',
                                       'bebop_listeners',
                                       'bebop_meta_object',
                                       'bebop_object_type',
                                       'bebop_options',
                                       'bebop_process_listeners',
                                       'bebop_widgets',
                                       'cat_cat_subcat_trans_index',
                                       'cat_categories',
                                       'cat_category_category_map',
                                       'cat_category_purpose_map',
                                       'cat_object_category_map',
                                       'cat_object_root_category_map',
                                       'cat_purposes',
                                       'cat_root_cat_object_map',
                                       'cms_article_image_map',
                                       'cms_articles',
                                       'cms_assets',
                                       'cms_bundles',
                                       'cms_category_template_map',
                                       'cms_files',
                                       'cms_folders',
                                       'cms_form_item',
                                       'cms_form_section_item',
                                       'cms_form_section_wrapper',
                                       'cms_image_mime_types',
                                       'cms_images',
                                       'cms_item_template_map',
                                       'cms_items',
                                       'cms_mime_extensions',
                                       'cms_mime_status',
                                       'cms_mime_types',
                                       'cms_pages',
                                       'cms_privileges',
                                       'cms_resource_map',
                                       'cms_resource_types',
                                       'cms_resources',
                                       'cms_section_locales_map',
                                       'cms_section_template_map',
                                       'cms_standalone_pages',
                                       'cms_task_types',
                                       'cms_tasks',
                                       'cms_template_use_contexts',
                                       'cms_templates',
                                       'cms_text',
                                       'cms_text_mime_types',
                                       'cms_text_pages',
                                       'cms_top_level_pages',
                                       'cms_user_defined_items',
                                       'cms_wf_notifications',
                                       'content_section_type_map',
                                       'content_sections',
                                       'content_type_lifecycle_map',
                                       'content_type_workflow_map',
                                       'content_types',
                                       'ct_agendas',
                                       'ct_articles',
                                       'ct_content_group_item_map',
                                       'ct_content_groups',
                                       'ct_events',
                                       'ct_item_file_attachments',
                                       'ct_jobs',
                                       'ct_legal_notices',
                                       'ct_minutes',
                                       'ct_mp_articles',
                                       'ct_mp_sections',
                                       'ct_news',
                                       'ct_press_releases',
                                       'ct_service',
                                       'cw_process_definitions',
                                       'cw_processes',
                                       'cw_system_tasks',
                                       'cw_task_comments',
                                       'cw_task_dependencies',
                                       'cw_task_group_assignees',
                                       'cw_task_listeners',
                                       'cw_task_user_assignees',
                                       'cw_tasks',
                                       'cw_user_tasks',
                                       'email_addresses',
                                       'forms_dataquery',
                                       'forms_dd_select',
                                       'forms_lstnr_conf_email',
                                       'forms_lstnr_conf_redirect',
                                       'forms_lstnr_simple_email',
                                       'forms_lstnr_tmpl_email',
                                       'forms_lstnr_xml_email',
                                       'forms_widget_label',
                                       'g11n_catalogs',
                                       'g11n_charsets',
                                       'g11n_locale_charset_map',
                                       'g11n_locales',
                                       'granted_context_non_leaf_map',
                                       'group_member_map',
                                       'group_member_trans_index',
                                       'group_subgroup_map',
                                       'group_subgroup_trans_index',
                                       'groups',
                                       'lifecycle_definitions',
                                       'lifecycles',
                                       'lucene_docs',
                                       'message_parts',
                                       'message_threads',
                                       'messages',
                                       'nt_digests',
                                       'nt_queue',
                                       'nt_requests',
                                       'object_container_map',
                                       'object_context',
                                       'object_context_map',
                                       'object_grants',
                                       'parameterized_privileges',
                                       'parties',
                                       'party_email_map',
                                       'persistence_dynamic_assoc',
                                       'persistence_dynamic_ot',
                                       'person_names',
                                       'phase_definitions',
                                       'phases',
                                       'portals',
                                       'portlet_content_item',
                                       'portlet_tasks',
                                       'portlets',
                                       'post_convert_html',
                                       'pre_convert_html',
                                       'preferences',
                                       'publish_to_fs_files',
                                       'publish_to_fs_links',
                                       'publish_to_fs_queue',
                                       'roles',
                                       'section_lifecycle_def_map',
                                       'section_workflow_template_map',
                                       'site_nodes',
                                       'ungranted_context_non_leaf_map',
                                       'user_authentication',
                                       'users',
                                       'vc_actions',
                                       'vc_generic_operations',
                                       'vc_objects',
                                       'vc_operations',
                                       'vc_transactions',
                                       'vcx_blob_operations',
                                       'vcx_clob_operations',
                                       'vcx_event_types',
                                       'vcx_generic_operations',
                                       'vcx_java_classes',
                                       'vcx_obj_changes',
                                       'vcx_operations',
                                       'vcx_tags',
                                       'vcx_txns',
                                       'web_hosts')
                     and b.relname in ('acs_auditing',
                                       'acs_object_lifecycle_map',
                                       'acs_objects',
                                       'acs_permissions',
                                       'acs_privileges',
                                       'acs_stylesheet_node_map',
                                       'acs_stylesheet_type_map',
                                       'acs_stylesheets',
                                       'apm_listeners',
                                       'apm_package_type_listener_map',
                                       'apm_package_types',
                                       'apm_packages',
                                       'application_type_privilege_map',
                                       'application_types',
                                       'applications',
                                       'authoring_kit_step_map',
                                       'authoring_kits',
                                       'authoring_steps',
                                       'bebop_component_hierarchy',
                                       'bebop_components',
                                       'bebop_form_process_listeners',
                                       'bebop_form_sections',
                                       'bebop_listener_map',
                                       'bebop_listeners',
                                       'bebop_meta_object',
                                       'bebop_object_type',
                                       'bebop_options',
                                       'bebop_process_listeners',
                                       'bebop_widgets',
                                       'cat_cat_subcat_trans_index',
                                       'cat_categories',
                                       'cat_category_category_map',
                                       'cat_category_purpose_map',
                                       'cat_object_category_map',
                                       'cat_object_root_category_map',
                                       'cat_purposes',
                                       'cat_root_cat_object_map',
                                       'cms_article_image_map',
                                       'cms_articles',
                                       'cms_assets',
                                       'cms_bundles',
                                       'cms_category_template_map',
                                       'cms_files',
                                       'cms_folders',
                                       'cms_form_item',
                                       'cms_form_section_item',
                                       'cms_form_section_wrapper',
                                       'cms_image_mime_types',
                                       'cms_images',
                                       'cms_item_template_map',
                                       'cms_items',
                                       'cms_mime_extensions',
                                       'cms_mime_status',
                                       'cms_mime_types',
                                       'cms_pages',
                                       'cms_privileges',
                                       'cms_resource_map',
                                       'cms_resource_types',
                                       'cms_resources',
                                       'cms_section_locales_map',
                                       'cms_section_template_map',
                                       'cms_standalone_pages',
                                       'cms_task_types',
                                       'cms_tasks',
                                       'cms_template_use_contexts',
                                       'cms_templates',
                                       'cms_text',
                                       'cms_text_mime_types',
                                       'cms_text_pages',
                                       'cms_top_level_pages',
                                       'cms_user_defined_items',
                                       'cms_wf_notifications',
                                       'content_section_type_map',
                                       'content_sections',
                                       'content_type_lifecycle_map',
                                       'content_type_workflow_map',
                                       'content_types',
                                       'ct_agendas',
                                       'ct_articles',
                                       'ct_content_group_item_map',
                                       'ct_content_groups',
                                       'ct_events',
                                       'ct_item_file_attachments',
                                       'ct_jobs',
                                       'ct_legal_notices',
                                       'ct_minutes',
                                       'ct_mp_articles',
                                       'ct_mp_sections',
                                       'ct_news',
                                       'ct_press_releases',
                                       'ct_service',
                                       'cw_process_definitions',
                                       'cw_processes',
                                       'cw_system_tasks',
                                       'cw_task_comments',
                                       'cw_task_dependencies',
                                       'cw_task_group_assignees',
                                       'cw_task_listeners',
                                       'cw_task_user_assignees',
                                       'cw_tasks',
                                       'cw_user_tasks',
                                       'email_addresses',
                                       'forms_dataquery',
                                       'forms_dd_select',
                                       'forms_lstnr_conf_email',
                                       'forms_lstnr_conf_redirect',
                                       'forms_lstnr_simple_email',
                                       'forms_lstnr_tmpl_email',
                                       'forms_lstnr_xml_email',
                                       'forms_widget_label',
                                       'g11n_catalogs',
                                       'g11n_charsets',
                                       'g11n_locale_charset_map',
                                       'g11n_locales',
                                       'granted_context_non_leaf_map',
                                       'group_member_map',
                                       'group_member_trans_index',
                                       'group_subgroup_map',
                                       'group_subgroup_trans_index',
                                       'groups',
                                       'lifecycle_definitions',
                                       'lifecycles',
                                       'lucene_docs',
                                       'message_parts',
                                       'message_threads',
                                       'messages',
                                       'nt_digests',
                                       'nt_queue',
                                       'nt_requests',
                                       'object_container_map',
                                       'object_context',
                                       'object_context_map',
                                       'object_grants',
                                       'parameterized_privileges',
                                       'parties',
                                       'party_email_map',
                                       'persistence_dynamic_assoc',
                                       'persistence_dynamic_ot',
                                       'person_names',
                                       'phase_definitions',
                                       'phases',
                                       'portals',
                                       'portlet_content_item',
                                       'portlet_tasks',
                                       'portlets',
                                       'post_convert_html',
                                       'pre_convert_html',
                                       'preferences',
                                       'publish_to_fs_files',
                                       'publish_to_fs_links',
                                       'publish_to_fs_queue',
                                       'roles',
                                       'section_lifecycle_def_map',
                                       'section_workflow_template_map',
                                       'site_nodes',
                                       'ungranted_context_non_leaf_map',
                                       'user_authentication',
                                       'users',
                                       'vc_actions',
                                       'vc_generic_operations',
                                       'vc_objects',
                                       'vc_operations',
                                       'vc_transactions',
                                       'vcx_blob_operations',
                                       'vcx_clob_operations',
                                       'vcx_event_types',
                                       'vcx_generic_operations',
                                       'vcx_java_classes',
                                       'vcx_obj_changes',
                                       'vcx_operations',
                                       'vcx_tags',
                                       'vcx_txns',
                                       'web_hosts')
                     and not ( a.relname in ('acs_auditing',
                                             'acs_objects',
                                             'acs_permissions',
                                             'acs_privileges',
                                             'acs_stylesheets',
                                             'acs_stylesheet_node_map',
                                             'acs_stylesheet_type_map',
                                             'apm_listeners',
                                             'apm_packages',
                                             'apm_package_types',
                                             'apm_package_type_listener_map',
                                             'applications',
                                             'application_types',
                                             'application_type_privilege_map',
                                             'bebop_components',
                                             'bebop_component_hierarchy',
                                             'bebop_form_process_listeners',
                                             'bebop_form_sections',
                                             'bebop_listeners',
                                             'bebop_listener_map',
                                             'bebop_meta_object',
                                             'bebop_object_type',
                                             'bebop_options',
                                             'bebop_process_listeners',
                                             'bebop_widgets',
                                             'cat_categories',
                                             'cat_category_category_map',
                                             'cat_category_purpose_map',
                                             'cat_cat_subcat_trans_index',
                                             'cat_object_category_map',
                                             'cat_object_root_category_map',
                                             'cat_purposes',
                                             'cat_root_cat_object_map',
                                             'cms_image_mime_types',
                                             'cms_mime_extensions',
                                             'cms_mime_status',
                                             'cms_mime_types',
                                             'cms_text_mime_types',
                                             'content_change_time',
                                             'cw_processes',
                                             'cw_process_definitions',
                                             'cw_system_tasks',
                                             'cw_tasks',
                                             'cw_task_comments',
                                             'cw_task_dependencies',
                                             'cw_task_group_assignees',
                                             'cw_task_listeners',
                                             'cw_task_user_assignees',
                                             'cw_user_tasks',
                                             'email_addresses',
                                             'forms_dataquery',
                                             'forms_dd_select',
                                             'forms_lstnr_conf_email',
                                             'forms_lstnr_conf_redirect',
                                             'forms_lstnr_simple_email',
                                             'forms_lstnr_tmpl_email',
                                             'forms_lstnr_xml_email',
                                             'forms_widget_label',
                                             'g11n_catalogs',
                                             'g11n_charsets',
                                             'g11n_locales',
                                             'g11n_locale_charset_map',
                                             'granted_context_non_leaf_map',
                                             'groups',
                                             'group_member_map',
                                             'group_member_trans_index',
                                             'group_subgroup_map',
                                             'group_subgroup_trans_index',
                                             'lucene_docs',
                                             'messages',
                                             'message_parts',
                                             'message_threads',
                                             'nt_digests',
                                             'nt_queue',
                                             'nt_requests',
                                             'object_container_map',
                                             'object_context',
                                             'object_context_map',
                                             'object_grants',
                                             'parameterized_privileges',
                                             'parties',
                                             'party_email_map',
                                             'persistence_dynamic_assoc',
                                             'persistence_dynamic_ot',
                                             'person_names',
                                             'portals',
                                             'portlets',
                                             'post_convert_html',
                                             'preferences',
                                             'pre_convert_html',
                                             'roles',
                                             'search_content',
                                             'search_indexing_jobs',
                                             'site_nodes',
                                             'ungranted_context_non_leaf_map',
                                             'users',
                                             'user_authentication',
                                             'vcx_blob_operations',
                                             'vcx_clob_operations',
                                             'vcx_event_types',
                                             'vcx_generic_operations',
                                             'vcx_java_classes',
                                             'vcx_obj_changes',
                                             'vcx_operations',
                                             'vcx_tags',
                                             'vcx_txns',
                                             'vc_actions',
                                             'vc_blob_operations',
                                             'vc_clob_operations',
                                             'vc_generic_operations',
                                             'vc_objects',
                                             'vc_operations',
                                             'vc_transactions',
                                             'web_hosts')
                           and b.relname in ('acs_auditing',
                                             'acs_objects',
                                             'acs_permissions',
                                             'acs_privileges',
                                             'acs_stylesheets',
                                             'acs_stylesheet_node_map',
                                             'acs_stylesheet_type_map',
                                             'apm_listeners',
                                             'apm_packages',
                                             'apm_package_types',
                                             'apm_package_type_listener_map',
                                             'applications',
                                             'application_types',
                                             'application_type_privilege_map',
                                             'bebop_components',
                                             'bebop_component_hierarchy',
                                             'bebop_form_process_listeners',
                                             'bebop_form_sections',
                                             'bebop_listeners',
                                             'bebop_listener_map',
                                             'bebop_meta_object',
                                             'bebop_object_type',
                                             'bebop_options',
                                             'bebop_process_listeners',
                                             'bebop_widgets',
                                             'cat_categories',
                                             'cat_category_category_map',
                                             'cat_category_purpose_map',
                                             'cat_cat_subcat_trans_index',
                                             'cat_object_category_map',
                                             'cat_object_root_category_map',
                                             'cat_purposes',
                                             'cat_root_cat_object_map',
                                             'cms_image_mime_types',
                                             'cms_mime_extensions',
                                             'cms_mime_status',
                                             'cms_mime_types',
                                             'cms_text_mime_types',
                                             'content_change_time',
                                             'cw_processes',
                                             'cw_process_definitions',
                                             'cw_system_tasks',
                                             'cw_tasks',
                                             'cw_task_comments',
                                             'cw_task_dependencies',
                                             'cw_task_group_assignees',
                                             'cw_task_listeners',
                                             'cw_task_user_assignees',
                                             'cw_user_tasks',
                                             'email_addresses',
                                             'forms_dataquery',
                                             'forms_dd_select',
                                             'forms_lstnr_conf_email',
                                             'forms_lstnr_conf_redirect',
                                             'forms_lstnr_simple_email',
                                             'forms_lstnr_tmpl_email',
                                             'forms_lstnr_xml_email',
                                             'forms_widget_label',
                                             'g11n_catalogs',
                                             'g11n_charsets',
                                             'g11n_locales',
                                             'g11n_locale_charset_map',
                                             'granted_context_non_leaf_map',
                                             'groups',
                                             'group_member_map',
                                             'group_member_trans_index',
                                             'group_subgroup_map',
                                             'group_subgroup_trans_index',
                                             'lucene_docs',
                                             'messages',
                                             'message_parts',
                                             'message_threads',
                                             'nt_digests',
                                             'nt_queue',
                                             'nt_requests',
                                             'object_container_map',
                                             'object_context',
                                             'object_context_map',
                                             'object_grants',
                                             'parameterized_privileges',
                                             'parties',
                                             'party_email_map',
                                             'persistence_dynamic_assoc',
                                             'persistence_dynamic_ot',
                                             'person_names',
                                             'portals',
                                             'portlets',
                                             'post_convert_html',
                                             'preferences',
                                             'pre_convert_html',
                                             'roles',
                                             'search_content',
                                             'search_indexing_jobs',
                                             'site_nodes',
                                             'ungranted_context_non_leaf_map',
                                             'users',
                                             'user_authentication',
                                             'vcx_blob_operations',
                                             'vcx_clob_operations',
                                             'vcx_event_types',
                                             'vcx_generic_operations',
                                             'vcx_java_classes',
                                             'vcx_obj_changes',
                                             'vcx_operations',
                                             'vcx_tags',
                                             'vcx_txns',
                                             'vc_actions',
                                             'vc_blob_operations',
                                             'vc_clob_operations',
                                             'vc_generic_operations',
                                             'vc_objects',
                                             'vc_operations',
                                             'vc_transactions',
                                             'web_hosts')));
update pg_class
   set reltriggers = (select count(*)
                        from pg_trigger t
                       where t.tgrelid = pg_class.oid)
 where relkind = 'r';
