/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.docrepo.InvalidMimeTypeFormatException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeExtension;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MimeTypeXMLLoader {
    private static final String XML_MIME_ROOT = "mimetypes";
    private static final String XML_MIME_NODE = "mimetype";
    private static final String XML_MIME_NAME = "name";
    private static final String XML_MIME_EXTENSION = "extension";
    private static final String XML_MIME_LABEL = "label";
    private static final String XML_MIME_CLASS = "class";

    public static void parse(InputStream is) throws IOException, InvalidMimeTypeFormatException {
        InputSource inputSrc = new InputSource(is);
        DOMParser parser = new DOMParser();
        try {
            parser.parse(inputSrc);
        }
        catch (SAXException e) {
            throw new InvalidMimeTypeFormatException(e);
        }
        MimeTypeXMLLoader.loadMimeTypes(parser.getDocument());
    }

    private static void loadMimeTypes(Document doc) throws InvalidMimeTypeFormatException {
        Element root = doc.getDocumentElement();
        if (root.getTagName().compareTo(XML_MIME_ROOT) != 0) {
            throw new InvalidMimeTypeFormatException("Invalid MIME type document");
        }
        NodeList nodeList = root.getElementsByTagName(XML_MIME_NODE);
        for (int j = 0; j < nodeList.getLength(); ++j) {
            MimeTypeXMLLoader.assertMimeType((Element)nodeList.item(j));
        }
    }

    private static void assertMimeType(Element element) {
        String name = element.getAttribute(XML_MIME_NAME);
        String extensions = element.getAttribute(XML_MIME_EXTENSION);
        String label = element.getAttribute(XML_MIME_LABEL);
        String objectType = element.getAttribute(XML_MIME_CLASS);
        if (null == objectType || "".equals(objectType)) {
            objectType = "MimeType";
        }
        String javaClass = "com.arsdigita.mimetypes." + objectType;
        String objType = "com.arsdigita.cms." + objectType;
        ArrayList<String> props = new ArrayList<String>(5);
        props.add(name);
        props.add(label);
        props.add(extensions);
        props.add(objectType);
        props.add("0");
        MimeType type = MimeType.loadMimeType((String)name);
        if (null == type) {
            type = MimeType.createMimeType((String)name, (String)javaClass, (String)objType);
        } else {
            type.setLabel(label);
            type.setJavaClass(javaClass);
            type.setSpecificObjectType(objType);
        }
        MimeTypeXMLLoader.updateMimeProperties(type, props);
        MimeTypeXMLLoader.updateFileExtensions(type, extensions);
    }

    private static void updateMimeProperties(MimeType type, ArrayList props) {
    }

    private static void updateFileExtensions(MimeType type, String extensions) {
        String[] ext = StringUtils.split((String)extensions, (char)',');
        for (int j = 0; j < ext.length; ++j) {
            MimeTypeExtension me;
            try {
                me = new MimeTypeExtension(new OID("mimeType", (Object)ext[j]));
            }
            catch (DataObjectNotFoundException e) {
                me = MimeTypeExtension.create((String)ext[j], (String)"mimeType");
            }
            me.save();
        }
    }
}

