/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

class FileActionPane
extends ColumnPanel
implements DRConstants {
    private FileInfoPropertiesPane m_parent;
    private RequestLocal m_fileData;
    private ActionLink m_newVersion;
    private Link m_download;
    private ActionLink m_email;
    private ActionLink m_delete;
    private static final Logger s_log = Logger.getLogger(FileActionPane.class);

    FileActionPane(FileInfoPropertiesPane parent) {
        super(1);
        this.m_parent = parent;
        this.m_fileData = new RequestLocal(){

            protected Object initialValue(PageState state) {
                BigDecimal id = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
                File file = null;
                try {
                    file = new File(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    throw new ObjectNotFoundException("The requested file no longer exists.");
                }
                return file;
            }
        };
        this.m_newVersion = this.addActionLink(FILE_NEW_VERSION_LINK);
        PrintListener printListener = new PrintListener(){

            public void prepare(PrintEvent e) {
                Link l = (Link)e.getTarget();
                PageState state = e.getPageState();
                File f = FileActionPane.this.getFile(state);
                l.setTarget("download/" + f.getName() + "?" + DRConstants.FILE_ID_PARAM.getName() + "=" + f.getID());
            }
        };
        this.m_download = new Link((Component)new Label(FILE_DOWNLOAD_LINK), printListener);
        this.m_download.setClassAttr("actionLink");
        this.add((Component)this.m_download);
        this.m_email = this.addActionLink(FILE_SEND_COLLEAGUE_LINK);
        this.m_delete = this.addActionLink(FILE_DELETE_LINK);
        this.m_newVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileActionPane.this.m_parent.displayUploadForm(e.getPageState());
            }
        });
        this.m_email.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileActionPane.this.m_parent.displaySendColleagueForm(e.getPageState());
            }
        });
        this.m_delete.addActionListener((ActionListener)new DeleteListener());
        this.m_delete.setConfirmation(FILE_DELETE_CONFIRM.localize().toString());
    }

    private ActionLink addActionLink(GlobalizedMessage msg) {
        ActionLink ln = new ActionLink((Component)new Label(msg));
        ln.setClassAttr("actionLink");
        this.add((Component)ln);
        return ln;
    }

    private File getFile(PageState s) {
        return (File)this.m_fileData.get(s);
    }

    private final class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            final File file = FileActionPane.this.getFile(state);
            String parentFolderID = file.getParent().getID().toString();
            KernelExcursion ex = new KernelExcursion(){

                protected void excurse() {
                    this.setEffectiveParty(Kernel.getSystemParty());
                    file.delete();
                }
            };
            ex.run();
            try {
                String appURI = this.getRedirectURI(state);
                DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)(appURI + "?" + DRConstants.SEL_FOLDER_ID_PARAM.getName() + "=" + parentFolderID));
            }
            catch (IOException iox) {
                throw new UncheckedWrapperException((Throwable)iox);
            }
        }

        private String getRedirectURI(PageState state) {
            String appURI = state.getRequestURI();
            s_log.debug((Object)("Original app URI: " + appURI));
            int idx = appURI.indexOf("/file/");
            appURI = appURI.substring(0, idx);
            String servletPath = Web.getConfig().getDispatcherServletPath();
            if (appURI.startsWith(servletPath)) {
                appURI = appURI.substring(servletPath.length());
            }
            s_log.debug((Object)("New URI: " + appURI));
            return appURI;
        }
    }
}

