/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.RepositoriesTable;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.HashSet;

class RepositoriesSelectionForm
extends Form
implements FormInitListener,
FormProcessListener,
DRConstants {
    private OptionGroup m_selection;
    private Hidden m_subscribed;
    private ArrayParameter m_origIDs;
    private RepositoriesTable m_table;
    private SingleSelect m_actionSelect;
    private StringParameter m_action = new StringParameter("folder-action");

    public RepositoriesSelectionForm(RepositoriesTable table) {
        super("FolderContentAction", (Container)new ColumnPanel(1));
        this.m_table = table;
        this.add((Component)this.m_table.getTable());
        this.m_selection = this.m_table.getCheckboxGroup();
        this.m_subscribed = this.m_table.getSubscribedHidden();
        this.add((Component)this.m_selection);
        this.add((Component)this.m_subscribed);
        this.add((Component)new Submit(REPOSITORIES_MOUNTED_SAVE));
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    public void register(Page p) {
        super.register(p);
    }

    public void reset(PageState state) {
        this.m_selection.setValue(state, (Object)this.m_table.getSelectedIDs(state));
        this.m_subscribed.setValue(state, (Object)this.m_table.getSelectedIDs(state));
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        this.reset(e.getPageState());
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        User subscriber = DRUtils.getUser(state);
        HashSet<BigDecimal> subscribed = new HashSet<BigDecimal>();
        BigDecimal[] subID = (BigDecimal[])this.m_subscribed.getValue(state);
        for (int i = 0; subID != null && i < subID.length; ++i) {
            subscribed.add(subID[i]);
        }
        HashSet<BigDecimal> selected = new HashSet<BigDecimal>();
        HashSet<BigDecimal> selected_bk = new HashSet<BigDecimal>();
        BigDecimal[] selID = (BigDecimal[])this.m_selection.getValue(state);
        for (int i = 0; selID != null && i < selID.length; ++i) {
            selected.add(selID[i]);
            selected_bk.add(selID[i]);
        }
        selected.removeAll(subscribed);
        if (selected.size() > 0) {
            DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.docrepo.addUserRepositoriesMapping");
            operation.setParameter("userID", (Object)subscriber.getID());
            operation.setParameter("repositoryIDs", selected);
            operation.execute();
            operation.close();
        }
        subscribed.removeAll(selected_bk);
        if (subscribed.size() > 0) {
            DataOperation operation = SessionManager.getSession().retrieveDataOperation("com.arsdigita.docrepo.removeUserRepositoriesMapping");
            operation.setParameter("userID", (Object)subscriber.getID());
            operation.setParameter("repositoryIDs", subscribed);
            operation.execute();
            operation.close();
        }
        this.reset(state);
    }
}

