/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.TypeChangeException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.CancelButton;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class VersionUploadForm
extends Form
implements FormInitListener,
FormProcessListener,
FormValidationListener,
DRConstants {
    private static final String VERSION_UPLOAD_FORM = "file-version";
    private static final String VERSION_TRANSACTION_DESCRIPTION = "file-transaction-description";
    private static final String VERSION_FILE_UPLOAD = "file-version-upload";
    private static Logger s_log = Logger.getLogger(VersionUploadForm.class);
    private FileUpload m_fileUpload;
    private StringParameter m_versionDesc;
    private RequestLocal m_fileData;
    private FileInfoPropertiesPane m_parent;
    private static int FOUR_K_CHAR_LIMIT = 1994;

    public VersionUploadForm(FileInfoPropertiesPane parent) {
        super(VERSION_UPLOAD_FORM, (Container)new ColumnPanel(2));
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_parent = parent;
        this.m_fileData = new RequestLocal(){

            protected Object initialValue(PageState state) {
                BigDecimal id = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
                File file = null;
                try {
                    file = new File(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    // empty catch block
                }
                return file;
            }
        };
        this.m_fileUpload = new FileUpload(VERSION_FILE_UPLOAD);
        this.m_fileUpload.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_versionDesc = new StringParameter(VERSION_TRANSACTION_DESCRIPTION);
        this.add((Component)new Label(FILE_NAME));
        this.add((Component)this.makeFileLabel());
        this.add((Component)new Label(FILE_SOURCE));
        this.add((Component)this.m_fileUpload);
        this.add((Component)new Label(FILE_VERSION_DESCRIPTION));
        TextArea fversionDesc = new TextArea((ParameterModel)this.m_versionDesc);
        fversionDesc.setRows(10);
        fversionDesc.setCols(40);
        fversionDesc.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)fversionDesc);
        Submit submit = new Submit(VERSION_FILE_UPLOAD);
        submit.setButtonLabel(FILE_SAVE);
        this.add((Component)new Label());
        SimpleContainer sc = new SimpleContainer();
        sc.add((Component)submit);
        CancelButton cancel = new CancelButton(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)sc, 1);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
    }

    private File getFile(PageState s) {
        return (File)this.m_fileData.get(s);
    }

    private Label makeFileLabel() {
        Label label = new Label();
        label.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Label t = (Label)e.getTarget();
                t.setLabel(VersionUploadForm.this.getFile(state).getName());
            }
        });
        return label;
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fpath = (String)data.get((Object)VERSION_FILE_UPLOAD);
        fpath = DRUtils.extractFileName(fpath, state);
        java.io.File src = null;
        if (fpath != null && fpath.length() > 0) {
            src = ((MultipartHttpServletRequest)e.getPageState().getRequest()).getFile(VERSION_FILE_UPLOAD);
        }
        File file = this.getFile(state);
        String vdesc = (String)data.get((Object)VERSION_TRANSACTION_DESCRIPTION);
        if (vdesc.length() > FOUR_K_CHAR_LIMIT) {
            vdesc = vdesc.substring(0, FOUR_K_CHAR_LIMIT);
        }
        try {
            file.saveNewRevision(src, fpath, vdesc);
        }
        catch (TypeChangeException ex) {
            throw new FormProcessException(ex.getMessage(), (Throwable)((Object)ex));
        }
        this.m_parent.displayPropertiesAndActions(state);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        String oldType;
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String uploadedFileName = (String)data.get((Object)VERSION_FILE_UPLOAD);
        String newType = Util.guessContentType(uploadedFileName, req);
        if (!newType.equalsIgnoreCase(oldType = this.getFile(state).getContentType())) {
            data.addError(VERSION_FILE_UPLOAD, DIFFERENT_MIMETYPE_ERROR.localize(req).toString());
        }
    }
}

