/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.exporter;

import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryNotFoundException;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

public class CategoryExporter {
    private static final Logger s_log = Logger.getLogger(CategoryExporter.class);
    public static final String TERMS_XML_NS = "http://xmlns.redhat.com/london/terms/1.0";
    private File m_expDir;
    private Map m_idMaps;

    public CategoryExporter(File expDir) {
        this.m_expDir = expDir;
        this.m_idMaps = new HashMap();
    }

    public void export(Category root, String key, URI url, String title, String description, String version, Date released) {
        this.export(root, key, url, title, description, version, released, true);
    }

    public void export(Category root, String key, URI url, String title, String description, String version, Date released, boolean exportItems) {
        this.exportDomain(root, key, url, title, description, version, released);
        this.exportHierarchy(root, key, url);
        if (exportItems) {
            this.exportItems(root, key, url);
        }
    }

    private void exportDomain(Category root, String key, URI url, String title, String description, String version, Date released) {
        Map idMap = this.getIDMap(url);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Element domain = new Element("terms:domain", TERMS_XML_NS);
        domain.addAttribute("about", url.toString());
        domain.addAttribute("key", key);
        domain.addAttribute("title", title);
        domain.addAttribute("version", version);
        domain.addAttribute("released", format.format(released));
        Element desc = domain.newChildElement("terms:description", TERMS_XML_NS);
        desc.setText(description);
        CategoryCollection cats = root.getDescendants();
        while (cats.next()) {
            Category cat = (Category)cats.getDomainObject();
            int id = idMap.size() + 1;
            idMap.put(cat, new Integer(id));
            if (cat.equals((Object)root)) continue;
            Element term = domain.newChildElement("terms:term", TERMS_XML_NS);
            term.addAttribute("id", Integer.valueOf(id).toString());
            term.addAttribute("name", cat.getName());
            term.addAttribute("inAtoZ", "false");
        }
        this.save(domain, key + "-domain.xml");
    }

    private void exportHierarchy(Category root, String key, URI url) {
        Category child;
        Map idMap = this.getIDMap(url);
        Element hier = new Element("terms:hierarchy", TERMS_XML_NS);
        Element domain = hier.newChildElement("terms:domain", TERMS_XML_NS);
        domain.addAttribute("resource", url.toString());
        CategoryCollection children = root.getChildren();
        while (children.next()) {
            child = (Category)children.getDomainObject();
            Element term = hier.newChildElement("terms:term", TERMS_XML_NS);
            term.addAttribute("id", idMap.get(child).toString());
        }
        children = root.getChildren();
        while (children.next()) {
            child = (Category)children.getDomainObject();
            this.exportChildren(idMap, child, hier);
        }
        this.save(hier, key + "-hierarchy.xml");
    }

    private void exportChildren(Map idMap, Category cat, Element root) {
        Category child;
        CategoryCollection children = cat.getChildren();
        while (children.next()) {
            child = (Category)children.getDomainObject();
            this.exportPair(idMap, cat, child, root);
        }
        children = cat.getChildren();
        while (children.next()) {
            child = (Category)children.getDomainObject();
            this.exportChildren(idMap, child, root);
        }
    }

    private void exportPair(Map idMap, Category srcCat, Category dstCat, Element root) {
        Element pair = root.newChildElement("terms:orderedPair", TERMS_XML_NS);
        Element src = pair.newChildElement("terms:source", TERMS_XML_NS);
        Element srcTerm = src.newChildElement("terms:term", TERMS_XML_NS);
        srcTerm.addAttribute("id", idMap.get(srcCat).toString());
        Element dst = pair.newChildElement("terms:destination", TERMS_XML_NS);
        Element dstTerm = dst.newChildElement("terms:term", TERMS_XML_NS);
        dstTerm.addAttribute("id", idMap.get(dstCat).toString());
        try {
            if (dstCat.getDefaultParentCategory().equals((Object)srcCat)) {
                dst.addAttribute("isDefault", "true");
            } else {
                dst.addAttribute("isDefault", "false");
            }
        }
        catch (CategoryNotFoundException e) {
            dst.addAttribute("isDefault", "false");
        }
        dst.addAttribute("isPreferred", "true");
    }

    private void exportItems(Category root, String key, URI url) {
        Map idMap = this.getIDMap(url);
        Element items = new Element("terms:itemMapping", TERMS_XML_NS);
        Element domain = items.newChildElement("terms:domain", TERMS_XML_NS);
        domain.addAttribute("resource", url.toString());
        CategoryCollection children = root.getDescendants();
        while (children.next()) {
            Category cat = (Category)children.getDomainObject();
            CategorizedCollection objs = cat.getObjects("com.arsdigita.cms.ContentPage", "parents");
            while (objs.next()) {
                ContentPage obj = (ContentPage)objs.getDomainObject();
                Element mapping = items.newChildElement("terms:mapping", TERMS_XML_NS);
                Element term = mapping.newChildElement("terms:term", TERMS_XML_NS);
                term.addAttribute("id", idMap.get(cat).toString());
                Element item = mapping.newChildElement("terms:item", TERMS_XML_NS);
                item.addAttribute("path", obj.getContentSection().getPath() + "/" + obj.getPathNoJsp());
            }
        }
        this.save(items, key + "-items.xml");
    }

    private Map getIDMap(URI url) {
        if (!this.m_idMaps.containsKey(url)) {
            this.m_idMaps.put(url, new HashMap());
        }
        return (Map)this.m_idMaps.get(url);
    }

    private void save(Element root, String filename) {
        Document doc = null;
        try {
            s_log.debug((Object)("Got root " + root));
            doc = new Document(root);
        }
        catch (ParserConfigurationException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        try {
            File dst = new File(this.m_expDir, filename);
            FileOutputStream os = new FileOutputStream(dst);
            os.write(doc.toString(true).getBytes("UTF-8"));
            os.flush();
            os.close();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot write file", (Throwable)ex);
        }
    }
}

