/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.contenttypes.GenericArticle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;

public class PressRelease
extends GenericArticle {
    public static final String CONTACT_INFO = "contactInfo";
    public static final String SUMMARY = "summary";
    public static final String REFERENCE_CODE = "referenceCode";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.PressRelease";
    public static final int SUMMARY_LENGTH = 200;

    public PressRelease() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public PressRelease(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PressRelease(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public PressRelease(DataObject obj) {
        super(obj);
    }

    public PressRelease(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public String getContactInfo() {
        return (String)this.get(CONTACT_INFO);
    }

    public void setContactInfo(String contactInfo) {
        this.set(CONTACT_INFO, contactInfo);
    }

    public String getSummary() {
        return (String)this.get(SUMMARY);
    }

    public void setSummary(String summary) {
        this.set(SUMMARY, summary);
    }

    public String getReferenceCode() {
        return (String)this.get(REFERENCE_CODE);
    }

    public void setReferenceCode(String refCode) {
        this.set(REFERENCE_CODE, refCode);
    }

    public String getSearchSummary() {
        return StringUtils.truncateString((String)this.getSummary(), (int)200, (boolean)true);
    }
}

