/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.categorization.Category;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CsvImporterConfig
extends AbstractConfig {
    private static final Logger LOGGER = Logger.getLogger(CsvImporterConfig.class);
    private Parameter defaultCategoryId = new IntegerParameter("com.arsdigita.cms.scipublications.importer.csv.default_category_id", 1, (Object)0);
    private Parameter departmentCategoryIds = new StringParameter("com.arsdigita.cms.scipublications.importer.csv.department_category_ids", 1, (Object)"");

    public CsvImporterConfig() {
        this.register(this.defaultCategoryId);
        this.register(this.departmentCategoryIds);
        this.loadInfo();
    }

    public Integer getDefaultCategoryId() {
        return (Integer)this.get(this.defaultCategoryId);
    }

    public Category getDefaultCategory() {
        Integer categoryId = this.getDefaultCategoryId();
        if (categoryId == 0) {
            return null;
        }
        return new Category(new BigDecimal(categoryId));
    }

    public String getDepartmentCategoryIds() {
        return (String)this.get(this.departmentCategoryIds);
    }

    public Map<String, Category> getDepartmentCategories() {
        String[] departmentTokens;
        String categoryIds = this.getDepartmentCategoryIds();
        HashMap<String, Category> categories = new HashMap<String, Category>();
        if (categoryIds == null || categoryIds.isEmpty()) {
            return categories;
        }
        for (String departmentToken : departmentTokens = categoryIds.split(";")) {
            this.processDepartmentToken(departmentToken, categories);
        }
        return categories;
    }

    private void processDepartmentToken(String departmentToken, Map<String, Category> categories) {
        String[] tokens = departmentToken.split(":");
        if (tokens.length != 2) {
            LOGGER.warn((Object)"Failed to parse department categories id property. Invalid department token.");
            return;
        }
        BigDecimal categoryId = new BigDecimal(tokens[1]);
        Category category = new Category(categoryId);
        categories.put(tokens[0], category);
    }
}

