/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.Expertise;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

class ExpertiseImporter
extends AbstractPublicationImporter<Expertise> {
    protected ExpertiseImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    protected Expertise importPublication() {
        Expertise expertise = (Expertise)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        if (data.getPlace() != null && !data.getPlace().isEmpty()) {
            if (!this.isPretend()) {
                expertise.setPlace(data.getPlace());
            }
            report.addField(new FieldImportReport("Place", data.getPlace()));
        }
        this.processNumberOfPages(expertise);
        return expertise;
    }

    private void processNumberOfPages(Expertise publication) {
        if (this.getData().getNumberOfPages() != null && !this.getData().getNumberOfPages().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getNumberOfPages());
                if (!this.isPretend()) {
                    publication.setNumberOfPages(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Number of pages", this.getData().getNumberOfPages()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse numberOfPages data in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    @Override
    protected Expertise createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new Expertise();
    }

    @Override
    protected PublicationBundle createBundle(Expertise expertise) {
        if (this.isPretend()) {
            return null;
        }
        return new PublicationBundle((ContentItem)expertise);
    }
}

