/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.InternetArticle;
import com.arsdigita.cms.contenttypes.InternetArticleBundle;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class InternetArticleImporter
extends AbstractPublicationImporter<InternetArticle> {
    public InternetArticleImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    public InternetArticle importPublication() {
        InternetArticle article = (InternetArticle)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        if (data.getPlace() != null && !data.getPlace().isEmpty()) {
            if (!this.isPretend()) {
                article.setPlace(data.getPlace());
            }
            report.addField(new FieldImportReport("Place", data.getPlace()));
        }
        this.processNumberOfPages(article);
        if (data.getEdition() != null && !data.getEdition().isEmpty()) {
            if (!this.isPretend()) {
                article.setEdition(data.getEdition());
            }
            report.addField(new FieldImportReport("Edition", data.getEdition()));
        }
        if (data.getIssn() != null && !data.getIssn().isEmpty()) {
            if (!this.isPretend()) {
                article.setISSN(data.getIssn());
            }
            report.addField(new FieldImportReport("ISSN", data.getIssn()));
        }
        this.processLastAccessed(article);
        this.processPublicationDate(article);
        if (data.getUrl() != null && !data.getUrl().isEmpty()) {
            if (!this.isPretend()) {
                article.setUrl(data.getUrl());
            }
            report.addField(new FieldImportReport("URL", data.getUrl()));
        }
        if (data.getUrn() != null && !data.getUrn().isEmpty()) {
            if (!this.isPretend()) {
                article.setUrn(data.getUrn());
            }
            report.addField(new FieldImportReport("URN", data.getUrn()));
        }
        if (data.getDoi() != null && !data.getDoi().isEmpty()) {
            if (!this.isPretend()) {
                article.setDoi(data.getDoi());
            }
            report.addField(new FieldImportReport("DOI", data.getDoi()));
        }
        return article;
    }

    private void processNumberOfPages(InternetArticle publication) {
        if (this.getData().getNumberOfPages() != null && !this.getData().getNumberOfPages().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getNumberOfPages());
                if (!this.isPretend()) {
                    publication.setNumberOfPages(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Number of pages", this.getData().getNumberOfPages()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse numberOfPages data in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    private void processLastAccessed(InternetArticle article) {
        if (this.getData().getLastAccess() != null && !this.getData().getLastAccess().isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd");
            try {
                Date date = dateFormat.parse(this.getData().getLastAccess());
                if (!this.isPretend()) {
                    article.setLastAccessed(date);
                }
                this.getReport().addField(new FieldImportReport("Last access", this.getData().getLastAccess()));
            }
            catch (ParseException ex) {
                this.getReport().addMessage(String.format("Failed to parse date of last access in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPublicationDate(InternetArticle article) {
        if (this.getData().getPublicationDate() != null && !this.getData().getPublicationDate().isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd");
            try {
                Date date = dateFormat.parse(this.getData().getPublicationDate());
                if (!this.isPretend()) {
                    article.setPublicationDate(date);
                }
                this.getReport().addField(new FieldImportReport("Publication date", this.getData().getPublicationDate()));
            }
            catch (ParseException ex) {
                this.getReport().addMessage(String.format("Failed to parse publication date in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    @Override
    protected InternetArticle createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new InternetArticle();
    }

    @Override
    protected PublicationBundle createBundle(InternetArticle article) {
        if (this.isPretend()) {
            return null;
        }
        return new InternetArticleBundle((ContentItem)article);
    }
}

