/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dabin;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitBundle;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.GenericPersonBundle;
import com.arsdigita.cms.contenttypes.Person;
import com.arsdigita.cms.contenttypes.SciMember;
import com.arsdigita.cms.contenttypes.SciProject;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.Term;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.cmd.Program;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;

public class OrgaImporter
extends Program {
    private Properties config;
    private Connection connection = null;
    private ContentSection projectsContentSection;
    private Folder projectsFolder;
    private ContentSection externalPersonsSection;
    private Folder externalPersonsFolder;
    private LifecycleDefinition instituteLifecycleDef;
    private LifecycleDefinition departmentsLifecycleDef;
    private LifecycleDefinition projectsLifecycleDef;
    private LifecycleDefinition externalPersonsLifecycleDef;
    private Domain termsDomain;
    private Term activeMemberTerm;
    private Term formerMemberTerm;
    private Term currentProjectsTerm;
    private Term finishedProjectsTerm;

    public OrgaImporter() {
        super("PersonImporter", "0.1.0", "configFile");
    }

    protected void doRun(CommandLine cmdLine) {
        System.out.println("");
        System.out.println("");
        System.out.println("OrgaImporter is starting...");
        String[] args = cmdLine.getArgs();
        if (args.length != 1) {
            System.out.println("Invalid number of arguments.");
            this.help(System.err);
            System.exit(-1);
        }
        this.config = new Properties();
        try {
            this.config.loadFromXML(new FileInputStream(args[0]));
        }
        catch (FileNotFoundException ex) {
            System.err.printf("Configuration file '%s' not found:\n", args[0]);
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
        catch (IOException ex) {
            System.err.printf("Failed to read configuration file '%s' not found:\n", args[0]);
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
        String mySqlHost = this.config.getProperty("mysql.host", "localhost").trim();
        String mySqlUser = this.config.getProperty("mysql.user").trim();
        String mySqlPassword = this.config.getProperty("mysql.password").trim();
        String mySqlDb = this.config.getProperty("mysql.db").trim();
        this.projectsContentSection = this.getContentSection(this.config.getProperty("projects.contentsection"));
        this.externalPersonsSection = this.getContentSection(this.config.getProperty("externalPersons.contentsection"));
        LifecycleDefinitionCollection lifecycles = this.projectsContentSection.getLifecycleDefinitions();
        lifecycles.next();
        this.projectsLifecycleDef = lifecycles.getLifecycleDefinition();
        lifecycles.close();
        lifecycles = this.externalPersonsSection.getLifecycleDefinitions();
        lifecycles.next();
        this.externalPersonsLifecycleDef = lifecycles.getLifecycleDefinition();
        lifecycles.close();
        this.projectsFolder = this.getOrCreateFolder(this.projectsContentSection, this.config.getProperty("projects.folder"));
        this.externalPersonsFolder = this.getOrCreateFolder(this.externalPersonsSection, this.config.getProperty("externalPersons.folder"));
        System.out.println("Trying to connect to DaBIn MySQL database with these parameters:");
        System.out.printf("Host     = '%s'\n", mySqlHost);
        System.out.printf("User     = '%s'\n", mySqlUser);
        System.out.printf("Password = '%s'\n", mySqlPassword);
        System.out.printf("Database = '%s'\n", mySqlDb);
        try {
            this.connection = DriverManager.getConnection(String.format("jdbc:mysql://%s/%s", mySqlHost, mySqlDb), mySqlUser, mySqlPassword);
        }
        catch (Exception ex) {
            System.err.println("Failed to connect to DaBIn MySQL database: ");
            ex.printStackTrace(System.err);
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception ex1) {
                System.err.println("Failed to close failed connection: ");
                ex1.printStackTrace(System.err);
            }
            System.exit(-1);
        }
        try {
            this.termsDomain = Domain.retrieve((String)this.config.getProperty("terms.domain.key"));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        this.activeMemberTerm = this.getOrCreateTerm(this.config.getProperty("terms.members.active"));
        this.formerMemberTerm = this.getOrCreateTerm(this.config.getProperty("terms.members.former"));
        this.currentProjectsTerm = this.getOrCreateTerm(this.config.getProperty("terms.projects.current"));
        this.finishedProjectsTerm = this.getOrCreateTerm(this.config.getProperty("terms.projects.finished"));
        TransactionContext tctx = SessionManager.getSession().getTransactionContext();
        tctx.beginTxn();
        try {
            this.linkMembersToDepartments();
            this.createProjects();
        }
        catch (Exception ex) {
            tctx.abortTxn();
            ex.printStackTrace(System.err);
        }
        tctx.commitTxn();
    }

    public static void main(String[] args) {
        new OrgaImporter().run(args);
    }

    private void linkMembersToDepartments() throws SQLException {
    }

    private void linkMemberToDepartment(int dabinDepartmentId, int dabinMemberId, String eigenschaft) {
        Term departmentActiveMembersTerm = this.getOrCreateTerm(this.config.getProperty(String.format("terms.members.%d.active", dabinDepartmentId)));
        Term departmentFormerMembersTerm = this.getOrCreateTerm(this.config.getProperty(String.format("terms.members.%d.former", dabinDepartmentId)));
        DataCollection members = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.SciMember");
        members.addFilter(String.format("dabinId = %d", dabinMemberId));
        if (members.isEmpty()) {
            System.out.printf("Member with DaBInId %d does not exist in CCM. Skiping.\n", dabinMemberId);
        } else {
            members.next();
            SciMember member = (SciMember)DomainObjectFactory.newInstance((DataObject)members.getDataObject());
            if ("Aktiv".equals(eigenschaft)) {
                this.activeMemberTerm.addObject((ACSObject)member);
                departmentActiveMembersTerm.addObject((ACSObject)member);
                this.activeMemberTerm.save();
                departmentActiveMembersTerm.save();
                member.save();
            } else if ("Ehemalig".equals(eigenschaft)) {
                this.formerMemberTerm.addObject((ACSObject)member);
                departmentFormerMembersTerm.addObject((ACSObject)member);
                this.formerMemberTerm.save();
                departmentFormerMembersTerm.save();
                member.save();
            } else {
                System.out.printf("Member %d is not a former or active member (unknown value for 'Eigenschaft'). Skiping.\n", dabinMemberId);
            }
        }
    }

    private void createProjects() throws SQLException {
        System.out.println("\nImporting projects from DaBIn into CCM...");
        Statement stmt = this.connection.createStatement(1004, 1008);
        ResultSet result = stmt.executeQuery("SELECT Projekt_Id, Name, Beginn, Ende, Abgeschlossen, Beschreibung, Finanzierung, Abteilung_Id FROM projekt WHERE Sprache = 'DE' ORDER BY Beginn, Ende");
        while (result.next()) {
            this.createProject(result.getInt(1), result.getString(2), result.getInt(3), result.getInt(4), result.getString(5), result.getString(6), result.getString(7), result.getInt(8));
        }
    }

    private void createProject(int projectId, String name, int begin, int end, String finished, String desc, String funding, int dabinDepartmentId) throws SQLException {
        Term term;
        System.out.printf("Creating project '%s'...\n", name);
        SciProject project = new SciProject();
        if (this.normalizeString(name).length() > 200) {
            project.setName(this.normalizeString(name).substring(0, 200));
        } else {
            project.setName(this.normalizeString(name));
        }
        project.setTitle(name);
        GregorianCalendar endCal = null;
        if (begin != 0) {
            GregorianCalendar beginCal = new GregorianCalendar(begin, 0, 1, 0, 0);
            project.setBegin(beginCal.getTime());
            project.setBeginSkipDay(Boolean.TRUE);
            project.setBeginSkipMonth(Boolean.TRUE);
        }
        if (end != 0) {
            endCal = new GregorianCalendar(end, 11, 31, 23, 59);
            project.setEnd(endCal.getTime());
            project.setEndSkipDay(Boolean.TRUE);
            project.setEndSkipMonth(Boolean.TRUE);
        }
        if ("YES".equals(finished) && end == 0) {
            System.out.printf("WARNING: Finished = true but no end date for project '%s'.\n", name);
        }
        project.setProjectDescription(desc);
        project.setFunding(funding);
        project.setContentSection(this.projectsContentSection);
        project.setLanguage("de");
        project.save();
        GenericOrganizationalUnitBundle bundle = new GenericOrganizationalUnitBundle((ContentItem)project);
        bundle.setContentSection(this.projectsContentSection);
        bundle.save();
        this.projectsFolder.addItem((ContentBundle)bundle);
        GregorianCalendar todayCal = new GregorianCalendar();
        if ("YES".equals(finished) || endCal != null && todayCal.compareTo(endCal) > 0) {
            term = this.getOrCreateTerm(this.config.getProperty(String.format("terms.projects.%d.finished", dabinDepartmentId)));
            this.finishedProjectsTerm.addObject((ACSObject)project);
            this.finishedProjectsTerm.addObject((ACSObject)project.getContentBundle());
            this.finishedProjectsTerm.save();
            project.save();
            project.getContentBundle().save();
            term.addObject((ACSObject)project);
            term.addObject((ACSObject)project.getContentBundle());
            term.save();
            project.save();
            project.getContentBundle().save();
        } else {
            term = this.getOrCreateTerm(this.config.getProperty(String.format("terms.projects.%d.current", dabinDepartmentId)));
            this.currentProjectsTerm.addObject((ACSObject)project);
            this.currentProjectsTerm.addObject((ACSObject)project.getContentBundle());
            this.currentProjectsTerm.save();
            project.save();
            project.getContentBundle().save();
            term.addObject((ACSObject)project);
            term.addObject((ACSObject)project.getContentBundle());
            term.save();
            project.save();
            project.getContentBundle().save();
        }
        Statement stmt = this.connection.createStatement(1004, 1008);
        ResultSet membersResult = stmt.executeQuery(String.format("SELECT person.Person_Id, Name, Vorname, Anrede, Auftrag, Eigenschaft FROM projektlink JOIN person ON projektlink.Person_Id = person.Person_Id WHERE Projekt_Id  = %d", projectId));
        while (membersResult.next()) {
            this.linkMember(project, membersResult.getInt(1), membersResult.getString(2), membersResult.getString(3), membersResult.getString(4), membersResult.getString(5), membersResult.getString(6));
        }
    }

    private void linkMember(SciProject project, int personDabinId, String surname, String givenname, String title, String auftrag, String eigenschaft) {
        DataCollection members = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.SciMember");
        members.addFilter(String.format("dabinId = %d", personDabinId));
        if (members.isEmpty()) {
            System.out.printf("No member with DaBIn ID %d found in CCM database. Creating as external person.\n", personDabinId);
            Person person = new Person();
            person.setSurname(surname);
            person.setGivenName(givenname);
            person.setTitlePre(title);
            person.setDabinId(Integer.valueOf(personDabinId));
            person.setContentSection(this.externalPersonsSection);
            person.setLanguage("de");
            person.save();
            GenericPersonBundle bundle = new GenericPersonBundle((ContentItem)person);
            bundle.setContentSection(this.externalPersonsSection);
            bundle.save();
            this.externalPersonsFolder.addItem((ContentBundle)bundle);
            project.addPerson((GenericPerson)person, this.auftragToRole(auftrag), this.eigenschaftToStatus(eigenschaft));
        } else {
            members.next();
            SciMember member = (SciMember)DomainObjectFactory.newInstance((DataObject)members.getDataObject());
            project.addPerson((GenericPerson)member, this.auftragToRole(auftrag), this.eigenschaftToStatus(eigenschaft));
        }
    }

    private String eigenschaftToStatus(String eigenschaft) {
        if ("Aktiv".equals(eigenschaft)) {
            return "active";
        }
        if ("Ehemalig".equals(eigenschaft)) {
            return "former";
        }
        System.err.printf("No mapping for Eigenschaft '%s'. Setting to 'UNKNOWN'.\n", eigenschaft);
        return "UNKNOWN";
    }

    private String auftragToRole(String auftrag) {
        if ("Direktor".equals(auftrag)) {
            return "head";
        }
        if ("Mitarbeiter".equals(auftrag)) {
            return "member";
        }
        if ("Sekretariat".equals(auftrag)) {
            return "office";
        }
        if ("Sprecher".equals(auftrag)) {
            return "speaker";
        }
        if ("Projektleitung".equals(auftrag)) {
            return "head";
        }
        System.err.printf("No mapping for Auftrag '%s'. Setting to 'member'.\n", auftrag);
        return "member";
    }

    private ContentSection getContentSection(String rawPath) {
        ContentSection _section;
        StringBuilder path = new StringBuilder();
        if (!rawPath.startsWith("/")) {
            path.append("/");
        }
        path.append(rawPath);
        if (!rawPath.endsWith("/")) {
            path.append("/");
        }
        if ((_section = (ContentSection)ContentSection.retrieveApplicationForPath((String)path.toString())) == null) {
            throw new DataObjectNotFoundException("Content section not found with path " + path);
        }
        return _section;
    }

    private Folder getOrCreateFolder(ContentSection section, String path) {
        String[] pathTokens;
        Folder root;
        Folder prev = root = section.getRootFolder();
        Folder current = root;
        for (String token : pathTokens = path.split("/")) {
            if ((current = (Folder)current.getItem(token, true)) == null) {
                current = this.createFolder(prev, token);
            }
            prev = current;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder createFolder(Folder parent, String name) {
        System.out.printf("Creating folder '%s/%s'...\n", parent.getName(), name);
        Folder folder = (Folder)parent.getItem(name, true);
        if (folder == null) {
            TransactionContext tctx = SessionManager.getSession().getTransactionContext();
            try {
                tctx.beginTxn();
                Folder newFolder = new Folder();
                newFolder.setName(name);
                newFolder.setLabel(name);
                newFolder.setParent((ACSObject)parent);
                tctx.commitTxn();
            }
            finally {
                if (tctx.inTxn()) {
                    tctx.abortTxn();
                    System.out.println("FAILED");
                    throw new IllegalStateException("Something is wrong.");
                }
            }
            folder = (Folder)parent.getItem(name, true);
        }
        System.out.println("OK");
        return folder;
    }

    private Term getOrCreateTerm(String path) {
        String[] tokens = path.split("/");
        Term prevTerm = null;
        Term term = null;
        for (String token : tokens) {
            String[] split = token.split(":");
            if (split.length < 2) {
                System.err.printf("***ERROR: Malformed path token '%s'. Abborting path check.\n", token);
                return null;
            }
            String uniqueId = split[0];
            String name = split[1];
            prevTerm = term;
            try {
                term = this.termsDomain.getTerm(uniqueId);
            }
            catch (DataObjectNotFoundException ex) {
                System.out.printf("Term '%s' does not exist. Creating...\n", token);
                this.createTerm(uniqueId, name, this.termsDomain, prevTerm);
                term = this.termsDomain.getTerm(uniqueId);
            }
        }
        return term;
    }

    private void createTerm(String uniqueId, String name, Domain domain, Term parent) {
        try {
            Term term = Term.create((String)uniqueId, (String)name, (boolean)false, (String)"", (Domain)domain);
            term.save();
            term = this.termsDomain.getTerm(term.getUniqueID());
            if (parent != null) {
                Term parentTerm = this.termsDomain.getTerm(parent.getUniqueID());
                parentTerm.addNarrowerTerm(term, true, true);
                parentTerm.save();
                term.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private Lifecycle createLifecycle(LifecycleDefinition def) {
        GregorianCalendar calendarNow = new GregorianCalendar();
        Date now = calendarNow.getTime();
        Lifecycle lifecycle = def.createLifecycle();
        lifecycle.setStartDate(now);
        return lifecycle;
    }

    private String normalizeString(String str) {
        if (str == null) {
            return "null";
        }
        return str.replace("\u00e4", "ae").replace("\u00f6", "oe").replace("\u00fc", "ue").replace("\u00c4", "Ae").replace("\u00dc", "Ue").replace("\u00d6", "Oe").replace("\u00df", "ss").replace(" ", "-").replaceAll("[^a-zA-Z0-9\\-]", "").toLowerCase().trim();
    }

    private void resolveDuplicateNameAndTitle(ContentPage page, Folder folder) {
        String resolvedName = page.getName();
        String resolvedTitle = page.getTitle();
        int i = 0;
        while (folder.getItem(resolvedName, false) != null) {
            resolvedName = String.format("%s-%d", page.getName(), ++i);
            resolvedTitle = String.format("%s (%d)", page.getTitle(), i);
        }
        page.setName(resolvedName);
        page.setTitle(resolvedTitle);
    }
}

