/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalworkspace.ui.homepage;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portalworkspace.Workspace;
import com.arsdigita.portalworkspace.ui.PersistentPortal;
import com.arsdigita.portalworkspace.ui.PortalSelectionModel;
import com.arsdigita.portalworkspace.ui.homepage.HomepagePortalSelectionModel;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class HomepageWorkspace
extends SimpleContainer {
    private static Logger s_log = Logger.getLogger(HomepageWorkspace.class);
    private HomepagePortalSelectionModel m_model;
    private ActionLink m_reset;
    private ActionLink m_browse;
    private ActionLink m_edit;
    private PersistentPortal m_browser;
    private PersistentPortal m_editor;
    private boolean m_customizable = false;
    private boolean m_readOnly;
    private String m_name;

    public HomepageWorkspace() {
        super("portal:homepageWorkspace", "http://www.uk.arsdigita.com/portal/1.0");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Constructor HomepageWorkspace finished. ");
        }
    }

    public void setModel(HomepagePortalSelectionModel model) {
        this.m_model = model;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("setModel: " + (Object)((Object)this.m_model)));
        }
    }

    public void setCustomizable(boolean customizable) {
        this.m_customizable = customizable;
    }

    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void addWidgets() {
        this.m_edit = new ActionLink("customize");
        this.m_browse = new ActionLink("browse");
        this.m_reset = new ActionLink("reset");
        this.m_reset.setConfirmation("Are you sure you wish to reset this column? This will permanently remove all portlets.");
        this.m_browser = new PersistentPortal((PortalSelectionModel)this.m_model, this.m_name, "display");
        this.m_editor = new PersistentPortal((PortalSelectionModel)this.m_model, this.m_name, "editor");
        this.m_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                HomepageWorkspace.this.setDisplayMode(state, false);
                HomepageWorkspace.this.m_model.onCustomize(state);
            }
        });
        this.m_browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                HomepageWorkspace.this.setDisplayMode(state, true);
            }
        });
        this.m_reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                HomepageWorkspace.this.setDisplayMode(state, true);
                HomepageWorkspace.this.m_model.onReset(state);
            }
        });
        this.add((Component)this.m_edit);
        this.add((Component)this.m_browse);
        this.add((Component)this.m_reset);
        this.add((Component)this.m_editor);
        this.add((Component)this.m_browser);
    }

    public void setDisplayMode(PageState state, boolean browse) {
        if (this.m_readOnly) {
            return;
        }
        this.m_browse.setVisible(state, !browse);
        this.m_reset.setVisible(state, !browse);
        this.m_edit.setVisible(state, browse);
        this.m_browser.setVisible(state, browse);
        this.m_editor.setVisible(state, !browse);
    }

    public void register(Page page) {
        super.register(page);
        page.setVisibleDefault((Component)this.m_browse, false);
        page.setVisibleDefault((Component)this.m_reset, false);
        page.setVisibleDefault((Component)this.m_edit, !this.m_readOnly);
        page.setVisibleDefault((Component)this.m_browser, true);
        page.setVisibleDefault((Component)this.m_editor, false);
    }

    public void generateXML(PageState state, Element parent) {
        Party party = Kernel.getContext().getParty();
        Workspace global = this.m_model.getWorkspaceModel().getGlobalWorkspace(state);
        PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)global, party);
        boolean hasAdmin = PermissionService.checkPermission((PermissionDescriptor)admin);
        boolean userWorkspaces = Workspace.getConfig().getCreateUserWorkspaces();
        if (party == null || this.m_readOnly || !hasAdmin && !this.m_customizable || !hasAdmin && !userWorkspaces) {
            this.m_reset.setVisible(state, false);
            this.m_browse.setVisible(state, false);
            this.m_edit.setVisible(state, false);
        }
        super.generateXML(state, parent);
    }
}

