/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz;

import com.arsdigita.atoz.AtoZGenerator;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.ItemAlias;
import com.arsdigita.atoz.ItemGenerator;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;

public class ItemProvider
extends AtoZProvider {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.atoz.ItemProvider";
    public static final String CATEGORY = "category";
    public static final String LOAD_PATHS = "loadPaths";
    public static final String ATOMIC_ENTRIES = "com.arsdigita.atoz.getAtomicItemEntries";

    public ItemProvider() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected ItemProvider(String type) {
        super(type);
    }

    public ItemProvider(DataObject obj) {
        super(obj);
    }

    public ItemProvider(OID oid) {
        super(oid);
    }

    public static ItemProvider create(String title, String description, Category category) {
        ItemProvider provider = new ItemProvider();
        provider.setup(title, description, category);
        return provider;
    }

    public DataQuery getAtomicEntries() {
        DataQuery items = SessionManager.getSession().retrieveQuery(ATOMIC_ENTRIES);
        items.setParameter("providerID", (Object)this.getID());
        return items;
    }

    protected void setup(String title, String description, Category category) {
        super.setup(title, description);
        this.setCategory(category);
    }

    public void setCategory(Category category) {
        Assert.exists((Object)category, Category.class);
        this.set(CATEGORY, category);
    }

    public Category getCategory() {
        if (this.get(CATEGORY) == null) {
            return null;
        }
        return new Category((DataObject)this.get(CATEGORY));
    }

    public DomainCollection getAliases() {
        DomainCollection aliases = new DomainCollection(SessionManager.getSession().retrieve(ItemAlias.BASE_DATA_OBJECT_TYPE));
        aliases.addFilter("itemProvider = :providerId").set("providerId", (Object)this.getID());
        aliases.addOrder("title");
        return aliases;
    }

    public void setLoadPaths(String loadPaths) {
        this.set(LOAD_PATHS, loadPaths);
    }

    public String getLoadPaths() {
        return (String)this.get(LOAD_PATHS);
    }

    @Override
    public AtoZGenerator getGenerator() {
        return new ItemGenerator(this);
    }
}

