/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class CategoryProviderContentTypeBlockForm
extends Form {
    private static final Logger s_log = Logger.getLogger(CategoryProviderContentTypeBlockForm.class);
    private static final String TYPE_ID = "tid";
    private ACSObjectSelectionModel m_provider;
    private SingleSelect m_type_picker;
    private SaveCancelSection m_buttons;

    public CategoryProviderContentTypeBlockForm(ACSObjectSelectionModel provider) {
        super("contentTypeBlockForm", (Container)new SimpleContainer());
        this.setRedirecting(true);
        this.m_provider = provider;
        this.m_type_picker = this.getContentTypeSelect();
        this.add((Component)this.m_type_picker);
        this.m_buttons = new SaveCancelSection((Container)new SimpleContainer());
        this.add((Component)this.m_buttons);
        this.addProcessListener(new ProviderProcessListener());
        this.addSubmissionListener(new ProviderSubmissionListener());
    }

    private SingleSelect getContentTypeSelect() {
        SingleSelect select = new SingleSelect((ParameterModel)new BigDecimalParameter(TYPE_ID));
        try {
            select.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    OptionGroup optionGroup = (OptionGroup)e.getTarget();
                    ContentTypeCollection ctc = ContentType.getRegisteredContentTypes();
                    ctc.addOrder("label");
                    while (ctc.next()) {
                        ContentType contentType = ctc.getContentType();
                        optionGroup.addOption(new Option(contentType.getID().toString(), contentType.getLabel()));
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new UncheckedWrapperException(e.getClass().getName() + e.getMessage(), (Throwable)e);
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException(e.getClass().getName() + e.getMessage(), (Throwable)e);
        }
        return select;
    }

    public class ProviderProcessListener
    implements FormProcessListener {
        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            CategoryProvider provider = (CategoryProvider)CategoryProviderContentTypeBlockForm.this.m_provider.getSelectedObject(state);
            BigDecimal contentTypeID = (BigDecimal)CategoryProviderContentTypeBlockForm.this.m_type_picker.getValue(state);
            if (contentTypeID == null) {
                return;
            }
            ContentType contentType = new ContentType(contentTypeID);
            if (contentType == null) {
                return;
            }
            provider.addContentTypeBlock(contentType);
            CategoryProviderContentTypeBlockForm.this.fireCompletionEvent(state);
        }
    }

    public class ProviderSubmissionListener
    implements FormSubmissionListener {
        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (CategoryProviderContentTypeBlockForm.this.m_buttons.getCancelButton().isSelected(state)) {
                CategoryProviderContentTypeBlockForm.this.fireCompletionEvent(state);
                throw new FormProcessException("cancel hit");
            }
        }
    }
}

