/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.ItemProvider;
import com.arsdigita.atoz.ui.admin.ProviderForm;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.ui.AbstractCategoryPicker;
import com.arsdigita.categorization.ui.CategoryPicker;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.TreeMap;

public class ItemProviderForm
extends ProviderForm {
    private CategoryPicker m_picker;
    private TextField m_loadPaths;

    public ItemProviderForm(ACSObjectSelectionModel provider) {
        super("itemProvider", ItemProvider.class, provider);
        this.setMetaDataAttribute("title", "Item provider properties");
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        this.m_loadPaths = new TextField("loadPaths");
        this.m_loadPaths.setMetaDataAttribute("label", "Attributes to retrieve");
        this.add((Component)this.m_loadPaths);
        this.m_loadPaths.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, 200));
        this.m_picker = new AllCategoryPicker("rootCategory");
        ((SimpleComponent)this.m_picker).setMetaDataAttribute("label", "Category filter");
        ((SingleSelect)this.m_picker).addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_picker);
    }

    @Override
    protected void processWidgets(PageState state, AtoZProvider provider) {
        super.processWidgets(state, provider);
        ItemProvider myprovider = (ItemProvider)provider;
        myprovider.setCategory(this.m_picker.getCategory(state));
        myprovider.setLoadPaths((String)this.m_loadPaths.getValue(state));
    }

    @Override
    protected void initWidgets(PageState state, AtoZProvider provider) {
        super.initWidgets(state, provider);
        ItemProvider myprovider = (ItemProvider)provider;
        if (provider != null) {
            this.m_picker.setCategory(state, myprovider.getCategory());
            this.m_loadPaths.setValue(state, (Object)myprovider.getLoadPaths());
        }
    }

    private class AllCategoryPicker
    extends AbstractCategoryPicker {
        public AllCategoryPicker(String name) {
            super(name);
        }

        protected void addOptions(PageState state, SingleSelect target) {
            target.addOption(new Option(null, "-- pick one --"));
            DataCollection domains = SessionManager.getSession().retrieve("com.arsdigita.london.terms.Domain");
            domains.addPath("model.id");
            domains.addPath("model.objectType");
            domains.addOrder("title");
            while (domains.next()) {
                Category rootCategory = (Category)DomainObjectFactory.newInstance((DataObject)((DataObject)domains.get("model")));
                this.categorySubtreePath(target, rootCategory, " > ");
            }
        }

        private void categorySubtreePath(SingleSelect target, Category root, String join) {
            DomainCollection cats = new DomainCollection(SessionManager.getSession().retrieve("com.arsdigita.categorization.Category"));
            cats.addFilter("defaultAncestors like :ancestors").set("ancestors", (Object)((String)DomainServiceInterfaceExposer.get((DomainObject)root, (String)"defaultAncestors") + "%"));
            cats.addEqualsFilter("parents.link.isDefault", (Object)Boolean.TRUE);
            cats.addOrder("defaultAncestors");
            cats.addPath("parents.id");
            TreeMap<String, Category> path2cat = new TreeMap<String, Category>();
            HashMap<BigDecimal, String> cat2path = new HashMap<BigDecimal, String>();
            path2cat.put(root.getName(), root);
            cat2path.put(root.getID(), root.getName());
            target.addOption(new Option(root.getOID().toString(), " +++++++++++++++++++++++++ " + root.getName() + " +++++++++++++++++++++++++ "));
            while (cats.next()) {
                Category cat = (Category)cats.getDomainObject();
                BigDecimal parent = (BigDecimal)cats.get("parents.id");
                if (parent == null) {
                    path2cat.put(cat.getName(), cat);
                    cat2path.put(cat.getID(), cat.getName());
                    target.addOption(new Option(cat.getOID().toString(), cat.getName()));
                    continue;
                }
                String parentPath = (String)cat2path.get(parent);
                String path = parentPath + join + cat.getName();
                path2cat.put(path, cat);
                cat2path.put(cat.getID(), path);
                int breakPos = 0;
                String prefix = "---";
                while ((breakPos = 1 + parentPath.indexOf(join, breakPos)) > 0) {
                    prefix = prefix + "---";
                }
                target.addOption(new Option(cat.getOID().toString(), prefix + " " + cat.getName()));
            }
        }
    }
}

