/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import org.apache.log4j.Logger;

public abstract class ProviderForm
extends Form {
    private static final Logger s_log = Logger.getLogger(ProviderForm.class);
    private ACSObjectSelectionModel m_provider;
    private Class m_providerType;
    private TextField m_title;
    private TextArea m_description;
    private SaveCancelSection m_buttons;

    public ProviderForm(String name, Class providerType, ACSObjectSelectionModel provider) {
        super(name, (Container)new SimpleContainer());
        this.setRedirecting(true);
        this.m_provider = provider;
        this.m_providerType = providerType;
        this.m_buttons = new SaveCancelSection((Container)new SimpleContainer());
        this.addWidgets();
        this.add((Component)this.m_buttons);
        this.addProcessListener(new ProviderProcessListener());
        this.addSubmissionListener(new ProviderSubmissionListener());
        this.addInitListener(new ProviderInitListener());
    }

    protected void addWidgets() {
        this.m_title = new TextField("title");
        this.m_title.setMetaDataAttribute("label", "Title");
        this.m_title.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 200));
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_title.setSize(80);
        this.m_description = new TextArea("description");
        this.m_description.setMetaDataAttribute("label", "Description");
        this.m_description.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 4000));
        this.m_description.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_description.setCols(80);
        this.m_description.setRows(5);
        this.add((Component)this.m_title);
        this.add((Component)this.m_description);
    }

    protected void processWidgets(PageState state, AtoZProvider provider) {
        provider.setTitle((String)this.m_title.getValue(state));
        provider.setDescription((String)this.m_description.getValue(state));
    }

    protected void initWidgets(PageState state, AtoZProvider provider) {
        if (provider != null) {
            this.m_title.setValue(state, (Object)provider.getTitle());
            this.m_description.setValue(state, (Object)provider.getDescription());
        }
    }

    private class ProviderInitListener
    implements FormInitListener {
        private ProviderInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            AtoZProvider provider = (AtoZProvider)ProviderForm.this.m_provider.getSelectedObject(state);
            if (provider != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Loading provider " + provider.getOID()));
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No provider available");
            }
            ProviderForm.this.initWidgets(state, provider);
        }
    }

    private class ProviderProcessListener
    implements FormProcessListener {
        private ProviderProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            AtoZProvider provider = (AtoZProvider)ProviderForm.this.m_provider.getSelectedObject(state);
            if (provider == null) {
                AtoZ atoz = (AtoZ)Kernel.getContext().getResource();
                Assert.exists((Object)((Object)atoz), AtoZ.class);
                provider = (AtoZProvider)((Object)Classes.newInstance((Class)ProviderForm.this.m_providerType));
                atoz.addProvider(provider);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Creating provider " + provider.getOID()));
                }
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Loading provider " + provider.getOID()));
            }
            ProviderForm.this.processWidgets(state, provider);
            ProviderForm.this.fireCompletionEvent(state);
        }
    }

    private class ProviderSubmissionListener
    implements FormSubmissionListener {
        private ProviderSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (ProviderForm.this.m_buttons.getCancelButton().isSelected(state)) {
                ProviderForm.this.fireCompletionEvent(state);
                throw new FormProcessException("cancel hit");
            }
        }
    }
}

