/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.faq.QAPair;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.TypedText;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Faq
extends Application {
    private static final Logger log = Logger.getLogger(Faq.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.faq.Faq";

    public Faq(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Faq(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)key));
    }

    public Faq(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static Faq create(String urlName, String title, Application parent) {
        return (Faq)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
    }

    public QAPair createQuestion(String question, String answer) {
        return this.createQuestion(question, new TypedText(answer, "text/html"));
    }

    public QAPair createQuestion(String question, TypedText answer) {
        Integer sortKey = this.getNextSortKey();
        QAPair qaPair = new QAPair();
        qaPair.setFaq(this);
        qaPair.setQuestion(question);
        qaPair.setAnswer(answer);
        qaPair.setSortKey(sortKey);
        qaPair.save();
        PermissionService.setContext((ACSObject)qaPair, (ACSObject)this);
        return qaPair;
    }

    void removeQAPair(QAPair qaPair) {
        this.remove("questions", (DomainObject)qaPair);
    }

    public DataAssociation getQAPairs() {
        return (DataAssociation)this.get("questions");
    }

    synchronized Integer getNextSortKey() {
        DataQuery nextVal = SessionManager.getSession().retrieveQuery("com.arsdigita.faq.nextSortKey");
        nextVal.setParameter("faqID", (Object)this.getID());
        Integer returnVal = null;
        if (!nextVal.next()) {
            throw new RuntimeException("No rows returned from a query guaranteed to return a row");
        }
        returnVal = (Integer)nextVal.get("nextSortKey");
        nextVal.close();
        return returnVal;
    }

    void swapOrder(QAPair qaPairA, QAPair qaPairB) {
        if (qaPairA.getFaq().equals((Object)this) && qaPairB.getFaq().equals((Object)this)) {
            log.debug((Object)"Security passed, swapping: ");
            Integer temp = qaPairA.getSortKey();
            qaPairA.setSortKey(qaPairB.getSortKey());
            qaPairB.setSortKey(temp);
            qaPairA.save();
            qaPairB.save();
            log.debug((Object)"Swapped: ");
        }
    }

    public String getServletPath() {
        return "/faq";
    }
}

