/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq;

import com.arsdigita.db.DbHelper;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.faq.Faq;
import com.arsdigita.faq.QAPair;
import com.arsdigita.faq.ui.FaqQuestionsPortlet;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;

public class Initializer
extends CompoundInitializer {
    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-faq.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent evt) {
        super.init(evt);
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.faq.Faq", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Faq(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.faq.FaqQuestionsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new FaqQuestionsPortlet(dataObject);
            }
        });
        URLFinder faqFinder = new URLFinder(){

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }

            public String find(OID oid) throws NoValidURLException {
                QAPair pair;
                try {
                    pair = (QAPair)DomainObjectFactory.newInstance((OID)oid);
                }
                catch (DataObjectNotFoundException e) {
                    throw new ObjectNotFoundException("No such FAQ item: " + oid + ". May have been deleted.");
                }
                String url = pair.getFaq().getPrimaryURL() + "#" + pair.getID();
                return url;
            }
        };
        URLService.registerFinder((String)"com.arsdigita.faq.QAPair", (URLFinder)faqFinder);
    }
}

