/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bundle;

import com.arsdigita.bundle.ObjectTypeTraversalAdapter;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SimpleObjectTypeTraversalAdapter
implements ObjectTypeTraversalAdapter {
    private static final Logger s_log = Logger.getLogger(SimpleObjectTypeTraversalAdapter.class);
    public static final int RULE_INCLUDE = 0;
    public static final int RULE_EXCLUDE = 1;
    private HashSet m_attr = new HashSet();
    private HashSet m_assoc = new HashSet();
    private int m_attrRule = 1;
    private int m_assocRule = 0;
    private SimpleObjectTypeTraversalAdapter m_parent;

    public SimpleObjectTypeTraversalAdapter() {
        this(null);
    }

    public SimpleObjectTypeTraversalAdapter(SimpleObjectTypeTraversalAdapter parent) {
        this.m_parent = parent;
    }

    public void setAttributeRule(int rule) {
        this.m_attrRule = rule;
    }

    public void setAssociationRule(int rule) {
        this.m_assocRule = rule;
    }

    public void addAttributeProperty(String prop) {
        this.m_attr.add(prop);
    }

    public void addAssociationProperty(String prop) {
        this.m_assoc.add(prop);
    }

    @Override
    public boolean processProperty(ObjectType obj, String path, Property prop) {
        if (prop.isAttribute()) {
            boolean result = this.m_attr.contains(path);
            s_log.debug((Object)("Check attr " + path + " contains " + result + " " + this.m_attrRule));
            if (!result && this.m_parent != null) {
                s_log.debug((Object)"No explicit rule, delegating to parent");
                return this.m_parent.processProperty(obj, path, prop);
            }
            return this.m_attrRule == 0 ? result : !result;
        }
        boolean result = this.m_assoc.contains(path);
        s_log.debug((Object)("Check assoc " + path + " contains " + result + " " + this.m_attrRule));
        if (!result && this.m_parent != null) {
            s_log.debug((Object)"No explicit rule, delegating to parent");
            return this.m_parent.processProperty(obj, path, prop);
        }
        return this.m_assocRule == 0 ? result : !result;
    }
}

