/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.xmlfeed.listener;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.contenttypes.xmlfeed.XMLFeed;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.ParameterMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class RetrieveListener
implements FormProcessListener {
    private static final Logger s_log = Logger.getLogger(RetrieveListener.class);
    public static final String REQUEST_RESULTS_KEY = "XML Feed Results";
    private XMLFeed m_feed;

    public RetrieveListener(XMLFeed feed) {
        this.m_feed = feed;
    }

    public XMLFeed getXMLFeed() {
        return this.m_feed;
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        XMLFeed xmlFeed = this.getXMLFeed();
        ParameterMap params = new ParameterMap();
        Iterator it = xmlFeed.getFormFieldNames();
        while (it.hasNext()) {
            String field = (String)it.next();
            String value = (String)data.get((Object)field);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Addng parameter " + field + " -> " + value));
            }
            params.setParameter(field.trim(), value.trim());
        }
        String query = xmlFeed.getURL() + params.toString();
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)("Final query is " + query));
        }
        StringWriter errors = new StringWriter();
        PrintWriter writer = new PrintWriter(errors);
        writer.println("Errors:");
        InputStream content = this.getContent(query, writer);
        if (null == content) {
            state.getRequest().setAttribute(REQUEST_RESULTS_KEY, (Object)errors.toString());
        } else {
            byte[] xslFile = null;
            FileAsset file = xmlFeed.getXSLFile();
            if (file != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    file.writeBytes((OutputStream)os);
                    os.flush();
                }
                catch (IOException ex) {
                    throw new UncheckedWrapperException("cannot write file", (Throwable)ex);
                }
                s_log.debug((Object)"Got XSL file as byte array");
                xslFile = os.toByteArray();
                s_log.debug((Object)("XSL is " + new String(xslFile)));
                String result = this.transform(xslFile, content);
                s_log.debug((Object)("Result is " + result));
                state.getRequest().setAttribute(REQUEST_RESULTS_KEY, (Object)result);
            }
        }
    }

    private InputStream getContent(String query, PrintWriter writer) {
        try {
            URL url = new URL(query);
            URLConnection connection = url.openConnection();
            connection.connect();
            return new BufferedInputStream(connection.getInputStream());
        }
        catch (MalformedURLException e) {
            writer.print("Query string: ");
            writer.print(query);
            writer.println(" is not valid.");
            return null;
        }
        catch (IOException e) {
            writer.println("Cannot contact remote server.");
            return null;
        }
    }

    private String transform(byte[] xslFile, InputStream xml) throws FormProcessException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xslFile);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(is));
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult();
            result.setWriter(writer);
            transformer.transform(new StreamSource(xml), result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new FormProcessException("Cannot create XSL transformer.", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new FormProcessException("Error during XSL transform.", (Throwable)e);
        }
    }
}

