/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ResourceExistsException;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class DocFolder
extends Folder
implements Resource {
    private static final Logger s_log = Logger.getLogger(DocFolder.class);
    public static final String DESCRIPTION = "description";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.docmgr.DocFolder";
    public static final String TYPE = "com.arsdigita.cms.docmgr.DocFolder";

    public DocFolder() {
        this("com.arsdigita.cms.docmgr.DocFolder");
        try {
            this.setContentType(ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.DocFolder"));
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize((String)"cms.contenttypes.event_type_not_registered").localize(), (Throwable)e);
        }
    }

    public DocFolder(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID("com.arsdigita.cms.docmgr.DocFolder", (Object)id));
    }

    public DocFolder(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public DocFolder(DataObject obj) {
        super(obj);
    }

    public DocFolder(String type) {
        super(type);
    }

    public DocFolder(String title, String descrip, DocFolder parent) {
        this("com.arsdigita.cms.docmgr.DocFolder");
        this.setTitle(title);
        this.setDescription(descrip);
        this.setParent((ACSObject)parent);
        this.setContentSection(parent.getContentSection());
        s_log.debug((Object)("creating docfolder: " + title));
    }

    public static DocFolder retrieveDocFolder(DataObject docfolderData) {
        DocFolder docfolder = (DocFolder)DomainObjectFactory.newInstance((DataObject)docfolderData);
        if (docfolder == null) {
            throw new RuntimeException("Domain object factory produced null docfolder for data object " + docfolderData);
        }
        return docfolder;
    }

    public DocFolder retrieveSubFolder(String folderTitle) throws DataObjectNotFoundException {
        Folder.ItemCollection items = this.getItems();
        items.addFolderFilter(true);
        items.addEqualsFilter("name", (Object)URLEncoder.encode(folderTitle));
        DocFolder df = null;
        if (items.next()) {
            df = (DocFolder)items.getContentItem();
        }
        items.close();
        if (df == null) {
            throw new DataObjectNotFoundException("No child, " + folderTitle + ", found for folder " + this.getTitle() + " (id is " + this.getID().toString());
        }
        return df;
    }

    public Resource retrieveSubResource(String resourceTitle) throws DataObjectNotFoundException {
        Folder.ItemCollection items = this.getItems();
        items.addEqualsFilter("name", (Object)URLEncoder.encode(resourceTitle));
        Resource r = null;
        if (items.next()) {
            r = items.isFolder() ? (DocFolder)items.getContentItem() : (Document)((ContentBundle)items.getContentItem()).getPrimaryInstance();
        }
        items.close();
        if (r == null) {
            throw new DataObjectNotFoundException("No child, " + resourceTitle + ", found for folder " + this.getTitle() + " (id is " + this.getID().toString());
        }
        return r;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.getLabel();
    }

    public void setTitle(String title) {
        this.setName(URLEncoder.encode(title));
        super.setLabel(title);
    }

    @Override
    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    @Override
    public Resource copyTo(Resource parent) throws ResourceExistsException {
        return this.copyTo(this.getTitle(), parent);
    }

    @Override
    public Resource copyTo(String name, Resource parent) throws ResourceExistsException {
        Folder.ItemCollection ic = ((Folder)parent).getItems();
        ic.addEqualsFilter("name", (Object)URLEncoder.encode(name));
        boolean resourceExists = ic.next();
        ic.close();
        if (resourceExists) {
            throw new ResourceExistsException("Copying document would result in duplicate: " + name);
        }
        DocFolder df = new DocFolder(this.getTitle(), this.getDescription(), (DocFolder)parent);
        df.save();
        return df;
    }

    @Override
    public Resource copyTo(String name) throws ResourceExistsException {
        return this.copyTo(name, this.getParentResource());
    }

    @Override
    public URL toURL() {
        try {
            return new URL("http://tod.example.net");
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            s_log.error((Object)ex.getMessage());
            return null;
        }
    }

    @Override
    public boolean isRoot() {
        return ((ContentItem)this.getParent()).getParent() == null || this.getParent().getSpecificObjectType().equals("com.arsdigita.cms.Folder");
    }

    @Override
    public Resource getParentResource() {
        DocFolder parent = (DocFolder)this.getParent();
        return parent;
    }

    @Override
    public void setParentResource(final Resource r) {
        this.setParent((ACSObject)r);
        this.save();
        final DocFolder thisResource = this;
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.setContext((ACSObject)thisResource, (ACSObject)((ACSObject)r));
            }
        }.run();
    }

    public static DocFolder getRootFolder(DocFolder f) {
        if (f.isRoot()) {
            return f;
        }
        return DocFolder.getRootFolder((DocFolder)f.getParentResource());
    }

    public static Repository getRepository(Resource r) {
        DocFolder f = null;
        f = r.isFolder() ? (DocFolder)r : (DocFolder)r.getParentResource();
        DocFolder rootFolder = DocFolder.getRootFolder(f);
        Repository rep = null;
        DataCollection dataCollection = SessionManager.getSession().retrieve("com.arsdigita.cms.docmgr.Repository");
        dataCollection.addEqualsFilter("rootID", (Object)rootFolder.getID().toString());
        long size = dataCollection.size();
        if (size > 1L) {
            s_log.error((Object)"should not have more than one repository per folder");
        }
        if (size == 0L) {
            s_log.error((Object)"root folder does not have a repository");
        } else {
            dataCollection.next();
            rep = new Repository(dataCollection.getDataObject());
        }
        dataCollection.close();
        return rep;
    }
}

