/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.ui.CategoryDocsNavigatorPortlet;
import com.arsdigita.cms.docmgr.ui.LegacyCategoryDocsNavigatorPortlet;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class RepositoryLoader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(RepositoryLoader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                RepositoryLoader.this.loadRepositoryApplicationType();
                RepositoryLoader.this.loadRepositoryPortletType(null);
                ApplicationType categoryBrowseDocsAppType = RepositoryLoader.this.loadCategoryBrowserType();
                RepositoryLoader.this.setupCategoryDocsPortlet(categoryBrowseDocsAppType);
                ApplicationType legacyCategoryBrowseDocsAppType = RepositoryLoader.this.loadLegacyCategoryBrowserType();
                RepositoryLoader.this.setupLegacyCategoryDocsPortlet(legacyCategoryBrowseDocsAppType);
                RepositoryLoader.this.setupDefaultDocRepository();
            }
        }.run();
        s_log.info((Object)"Done");
    }

    private ApplicationType loadRepositoryApplicationType() {
        ApplicationType type = new ApplicationType("CMSDocs", "com.arsdigita.cms.docmgr.Repository");
        type.setDescription("The document repository empowers users to share documents.");
        return type;
    }

    private ApplicationType loadCategoryBrowserType() {
        ApplicationType type = new ApplicationType("cmsdocs-categories", "com.arsdigita.cms.docmgr.DocumentCategoryBrowserApplication");
        type.setDescription("Browse documents by category.");
        return type;
    }

    private ApplicationType loadLegacyCategoryBrowserType() {
        ApplicationType type = new ApplicationType("cmsdocs-categories-legacy", "com.arsdigita.cms.docmgr.LegacyCategoryBrowserApplication");
        type.setDescription("Browse documents by legacy category (Taxonomie Browser).");
        return type;
    }

    private void setupDefaultDocRepository() {
        Repository repo = Repository.create("cmsdocs-repo", "Default DocumentMgr Repository", null);
        repo.save();
    }

    private void loadRepositoryPortletType(ApplicationType provider) {
        AppPortletType type = AppPortletType.createAppPortletType((String)"Portal Bookmarks", (String)"narrow", (String)"com.arsdigita.cms.docmgr.ui.RecentUpdatedDocsPortlet");
        type.setProviderApplicationType("com.arsdigita.cms.docmgr.Repository");
        type.setDescription("Displays the most recent documents in the document repository.");
    }

    private void setupCategoryDocsPortlet(ApplicationType provider) {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.cms.docmgr.ui.CategoryDocsNavigatorPortlet");
        setup.setTitle("Document Category Navigator");
        setup.setDescription("Browse documents by category.");
        setup.setProfile("wide");
        setup.setProviderApplicationType(provider);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new CategoryDocsNavigatorPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupLegacyCategoryDocsPortlet(ApplicationType provider) {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.cms.docmgr.ui.LegacyCategoryDocsNavigatorPortlet");
        setup.setTitle("Taxonomy Browser");
        setup.setDescription("Browse documents by category.");
        setup.setProfile("wide");
        setup.setProviderApplicationType(provider);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new LegacyCategoryDocsNavigatorPortlet(dataObject);
            }
        });
        setup.run();
    }
}

