/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.search;

import com.arsdigita.cms.docmgr.search.IntermediaSearchResults;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.search.Searcher;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.search.intermedia.SearchDataQuery;
import com.arsdigita.search.intermedia.SearchSpecification;
import com.arsdigita.search.intermedia.SimpleSearchSpecification;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class IntermediaSearcher
implements Searcher {
    protected static final String[] m_columns = new String[]{"object_id", "object_type", "summary", "link_text", "url_stub", "score"};
    private static final Logger s_log = Logger.getLogger(IntermediaSearcher.class);
    private static SimpleDateFormat lastModifiedDateFormatter = new SimpleDateFormat("yyyy MM dd HH:mm");

    @Override
    public SearchResults simpleSearch(String terms, User user) {
        String cleaned = this.cleanUpSearchString(terms, " and ");
        String searchString = this.createSearchString(null, null, cleaned, null, null, null, null, null);
        SearchDataQuery query = this.createSimpleQuery(searchString, user);
        return new IntermediaSearchResults(query);
    }

    protected SearchDataQuery createSimpleQuery(String searchString, User user) {
        Session session = SessionManager.getSession();
        SearchDataQuery q = new SearchDataQuery(session, searchString, m_columns);
        return q;
    }

    @Override
    public SearchResults advancedSearch(String terms, String author, String mimeType, BigDecimal workspaceID, Date lastModifiedStartDate, Date lastModifiedEndDate, String[] types, String[] sections, User user, Collection categoryIDs) {
        String cleanedTerms = this.cleanUpSearchString(terms, " and ");
        String cleanedAuthor = this.cleanUpSearchString(author, " ");
        String cleanedMimeType = this.cleanUpSearchString(mimeType, " ");
        String searchString = this.createSearchString(types, sections, cleanedTerms, cleanedAuthor, cleanedMimeType, workspaceID, lastModifiedStartDate, lastModifiedEndDate);
        SearchDataQuery query = this.createAdvancedQuery(searchString, user, categoryIDs);
        return new IntermediaSearchResults(query);
    }

    protected SearchDataQuery createAdvancedQuery(String searchString, User user, Collection categoryIDs) {
        SearchDataQuery query;
        SearchSpecification spec = new SearchSpecification(searchString, m_columns);
        SearchDataQuery lpq = query = (SearchDataQuery)spec.getPage(1);
        if (categoryIDs != null && !categoryIDs.isEmpty()) {
            Filter catFilter = lpq.addInSubqueryFilter("object_id", "com.arsdigita.categorization.cmsIDsInMultipleSubtrees");
            catFilter.set("categoryIDs", (Object)categoryIDs);
            Iterator i = categoryIDs.iterator();
            while (i.hasNext()) {
                s_log.debug((Object)("categoryIDs: " + i.next().toString()));
            }
        }
        s_log.debug((Object)("lpq " + lpq.toString()));
        return lpq;
    }

    protected String cleanUpSearchString(String terms, String joiner) {
        return SimpleSearchSpecification.cleanSearchString((String)terms, (String)joiner);
    }

    protected String createSearchString(String[] types, String[] sections, String searchString, String author, String mimeType, BigDecimal workspaceID, Date lastModifiedStartDate, Date lastModifiedEndDate) {
        Vector<String> from = new Vector<String>();
        Vector<String> where_clause = new Vector<String>();
        String s = "select c.object_id, c.object_type, c.link_text, c.url_stub, c.summary ";
        from.add("search_content c");
        if (searchString != null && searchString.length() > 0) {
            s = s + ", (score(1)+score(2)) as score ";
            where_clause.add(SimpleSearchSpecification.containsClause((String)"c", (String)searchString, (String)"1", (String)"2"));
        } else {
            s = s + ", 1 as score ";
        }
        if (author != null && author.length() > 0) {
            where_clause.add("contains(c.xml_content," + IntermediaSearcher.quote(author + " within author") + ",3) > 0");
        }
        if (mimeType != null && mimeType.length() > 0) {
            where_clause.add("contains(c.xml_content," + IntermediaSearcher.quote(mimeType + " within mimeType") + ",4) > 0");
        }
        if (workspaceID != null) {
            where_clause.add("contains(c.xml_content," + IntermediaSearcher.quote("\"" + workspaceID.toString() + "\" within workspace") + ",5) > 0");
        }
        if (lastModifiedStartDate != null || lastModifiedEndDate != null) {
            from.add("cms_documents cd");
            where_clause.add("cs.item_id = cd.doc_id");
            if (lastModifiedStartDate != null) {
                where_clause.add("cd.last_modified_cached > to_date('" + lastModifiedDateFormatter.format(lastModifiedStartDate) + "','YYYY MM DD HH24:MI')");
            }
            if (lastModifiedEndDate != null) {
                where_clause.add("cd.last_modified_cached < to_date('" + lastModifiedDateFormatter.format(lastModifiedEndDate) + "','YYYY MM DD HH24:MI')");
            }
        }
        if (types != null && types.length > 0) {
            from.add("content_types ct");
            where_clause.add("ct.type_id in (" + StringUtils.join((String[])types, (char)',') + ")");
            where_clause.add("ct.object_type = c.object_type");
        }
        if (sections != null && sections.length > 0) {
            from.add("cms_items cs");
            where_clause.add("cs.item_id = c.object_id");
            where_clause.add("cs.section_id in (" + StringUtils.join((String[])sections, (char)',') + ")");
        }
        s = s + " from " + StringUtils.join((String[])this.objectToString(from.toArray()), (char)',');
        s = s + " where " + StringUtils.join((String[])this.objectToString(where_clause.toArray()), (String)" and ");
        if (searchString != null && searchString.length() > 0) {
            s = s + " order by score desc";
        }
        s_log.debug((Object)("Search query: " + s));
        return s;
    }

    protected String[] objectToString(Object[] objects) {
        String[] results = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = objects[i].toString();
        }
        return results;
    }

    private static String quote(String text) {
        char q = '\'';
        StringBuffer result = new StringBuffer(text.length());
        result.append(q);
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == q) {
                result.append(q);
            }
            result.append(c[i]);
        }
        return result.append(q).toString();
    }
}

