/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BrowseFolderEdit
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener,
DMConstants {
    private static final Logger s_log = Logger.getLogger(BrowseFolderEdit.class);
    private StringParameter m_FolderName;
    private StringParameter m_FolderDesc;
    private BrowsePane m_parent;
    private BigDecimalParameter m_folderID;
    private Submit m_submit;
    private TextField m_FolderNameTF;
    private TextArea m_FolderDescTA;

    public BrowseFolderEdit(BrowsePane parent, BigDecimalParameter folderID) {
        super("EditFolderForm", (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_folderID = folderID;
        this.add((Component)FOLDER_NAME_LABEL);
        this.m_FolderName = new StringParameter("folder-name");
        this.m_FolderNameTF = new TextField((ParameterModel)this.m_FolderName);
        this.add((Component)this.m_FolderNameTF);
        this.add((Component)FOLDER_DESCRIPTION_LABEL);
        this.m_FolderDesc = new StringParameter("folder-description");
        this.m_FolderDescTA = new TextArea((ParameterModel)this.m_FolderDesc);
        this.m_FolderDescTA.setRows(10);
        this.m_FolderDescTA.setCols(40);
        this.add((Component)this.m_FolderDescTA);
        SimpleContainer sc = new SimpleContainer();
        this.m_submit = new Submit("submit");
        this.m_submit.setButtonLabel("Save");
        sc.add((Component)this.m_submit);
        Submit cancel = new Submit(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
    }

    public void init(FormSectionEvent e) {
        s_log.debug((Object)"init");
        PageState state = e.getPageState();
        BigDecimal folderID = (BigDecimal)state.getValue((ParameterModel)this.m_folderID);
        DocFolder f = new DocFolder(folderID);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("init widgets: name=" + f.getTitle() + "; description=" + f.getDescription()));
        }
        this.m_FolderNameTF.setValue(state, (Object)f.getTitle());
        this.m_FolderDescTA.setValue(state, (Object)f.getDescription());
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.m_submit.isSelected(state)) {
            String fDesc;
            FormData data = event.getFormData();
            String fname = (String)data.get((Object)"folder-name");
            if (fname == null || fname.trim().length() == 0) {
                data.addError("folder-name", "This parameter is required");
            }
            if (fname != null && fname.length() > 200) {
                data.addError("folder-name", "This parameter is too long. It must be fewer than 200 characters.");
            }
            if ((fDesc = (String)data.get((Object)"folder-description")) != null && fDesc.length() > 4000) {
                data.addError("folder-description", "This parameter is too long. It must be fewer than 4000 characters.");
            }
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (this.m_submit.isSelected(state)) {
            FormData data = e.getFormData();
            String fname = (String)data.get((Object)"folder-name");
            String fdesc = (String)data.get((Object)"folder-description");
            BigDecimal folderID = (BigDecimal)state.getValue((ParameterModel)this.m_folderID);
            DocFolder f = new DocFolder(folderID);
            f.setTitle(fname);
            f.setDescription(fdesc);
            f.save();
        }
        this.m_parent.displayFolderContentPanel(state);
    }
}

