/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ResourceExistsException;
import com.arsdigita.cms.docmgr.ui.BrowsePane;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

class DestinationFolderForm
extends Form
implements FormInitListener,
FormProcessListener,
DMConstants {
    public static final String TYPE_REPOSITORY = "repository";
    public static final String TYPE_FOLDER = "folder";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    private static final Logger s_log = Logger.getLogger(DestinationFolderForm.class);
    private Hidden m_resourceList;
    private ExpandedFolderTree m_radioGroup;
    private Submit m_copySubmit;
    private Submit m_moveSubmit;
    private BrowsePane m_parent;

    public DestinationFolderForm(BrowsePane parent) {
        super("Destination-Folder", (Container)new ColumnPanel(1));
        this.m_parent = parent;
        this.m_resourceList = new Hidden((ParameterModel)new ArrayParameter("resourceList"));
        this.add((Component)this.m_resourceList);
        this.m_radioGroup = new ExpandedFolderTree();
        this.add((Component)this.m_radioGroup);
        this.m_copySubmit = new Submit("Copy");
        this.add((Component)this.m_copySubmit);
        this.m_moveSubmit = new Submit("Move");
        this.add((Component)this.m_moveSubmit);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    public void generateXML(PageState ps, Element parent) {
        this.doSubmit(ps);
        if (this.isVisible(ps)) {
            Element form = this.generateXMLSansState(ps, parent);
            ps.setControlEvent((Component)this);
            ps.generateXML(form, this.getModel().getParametersToExclude());
            ps.clearControlEvent();
            form.addAttribute("isCopy", !this.m_moveSubmit.isVisible(ps) ? VALUE_YES : VALUE_NO);
            form.addAttribute("isMove", this.m_moveSubmit.isVisible(ps) ? VALUE_YES : VALUE_NO);
            try {
                Object[] resourceIDs = (Object[])this.m_resourceList.getValue(ps);
                if (resourceIDs != null) {
                    if (resourceIDs.length == 1) {
                        this.addResourceAttribute(form, "resourceTitle", (String)resourceIDs[0]);
                    } else {
                        for (int i = 0; i < resourceIDs.length; ++i) {
                            this.addResourceAttribute(form, "resourceTitle" + i, (String)resourceIDs[i]);
                        }
                    }
                }
            }
            catch (Throwable e) {
                s_log.error((Object)"", e);
            }
        }
    }

    private void addResourceAttribute(Element form, String attrName, String resourceIDtxt) throws Exception {
        BigDecimal id = new BigDecimal(resourceIDtxt);
        ContentItem ci = new ContentItem(id);
        OID oid = ci.getSpecificOID();
        Resource resource = (Resource)DomainObjectFactory.newInstance((OID)oid);
        form.addAttribute(attrName, resource.getTitle());
    }

    private void doSubmit(PageState ps) {
        Object[] list = (Object[])this.m_resourceList.getValue(ps);
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < list.length; ++i) {
            l.add(list[i]);
        }
        this.m_radioGroup.setSources(ps, l);
    }

    public void setResourceList(PageState state, Object[] list) {
        this.m_resourceList.setValue(state, (Object)list);
    }

    public void setCopy(PageState state) {
        state.setVisible((Component)this.m_moveSubmit, false);
        state.setVisible((Component)this.m_copySubmit, true);
    }

    public void setMove(PageState state) {
        state.setVisible((Component)this.m_moveSubmit, true);
        state.setVisible((Component)this.m_copySubmit, false);
    }

    public void init(FormSectionEvent e) {
        if (Kernel.getContext().getParty() == null) {
            throw new LoginSignal(e.getPageState().getRequest());
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        boolean isCopy = true;
        boolean isError = false;
        ArrayList<String> msgList = new ArrayList<String>();
        if (this.m_moveSubmit.isSelected(state)) {
            isCopy = false;
        }
        try {
            String parent = (String)this.m_radioGroup.getValue(state);
            if (parent == null) {
                throw new FormValidationException("Please choose a destination.");
            }
            OID parentOID = new OID("com.arsdigita.cms.docmgr.DocFolder", (Object)new BigDecimal(parent));
            DocFolder parentResource = (DocFolder)DomainObjectFactory.newInstance((OID)parentOID);
            String[] resourceIDs = (String[])this.m_resourceList.getValue(state);
            for (int i = 0; i < resourceIDs.length; ++i) {
                BigDecimal id = new BigDecimal(resourceIDs[i]);
                ContentItem ci = new ContentItem(new OID("com.arsdigita.cms.ContentItem", (Object)id));
                OID oid = ci.getSpecificOID();
                Resource resource = null;
                try {
                    resource = (Resource)DomainObjectFactory.newInstance((OID)oid);
                    if (isCopy) {
                        resource.copyTo(parentResource);
                        continue;
                    }
                    resource.setParentResource(parentResource);
                    continue;
                }
                catch (PersistenceException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getTitle());
                    continue;
                }
                catch (DataObjectNotFoundException exc) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getTitle());
                    continue;
                }
                catch (ResourceExistsException reex) {
                    isError = true;
                    if (resource == null) continue;
                    msgList.add(resource.getTitle() + " already exists in destination folder");
                }
            }
        }
        catch (DataObjectNotFoundException exc) {
            isError = true;
        }
        if (isError) {
            String action = null;
            action = isCopy ? "copy" : "move";
            this.m_parent.displayErrorMsgPanel(state, action, msgList);
        } else {
            this.m_parent.displayFolderContentPanel(state);
        }
    }

    private class ExpandedFolderTree
    extends RadioGroup {
        private RequestLocal m_srcResources;

        public ExpandedFolderTree() {
            super("resourceID");
            this.m_srcResources = new RequestLocal();
        }

        public void setSources(PageState state, ArrayList list) {
            this.m_srcResources.set(state, (Object)list);
        }

        public void generateXML(PageState state, Element parent) {
            Element treeElement = parent.newChildElement("bebop:tree", "http://www.arsdigita.com/bebop/1.0");
            HashMap<Object, Element> map = new HashMap<Object, Element>();
            map.put("-1", treeElement);
            BigDecimal sourceFolderID = DestinationFolderForm.this.m_parent.getFolderID(state);
            Repository parentApplication = (Repository)Web.getContext().getApplication();
            do {
                s_log.debug((Object)("app class: " + ((Object)((Object)parentApplication)).getClass().getName()));
            } while ((parentApplication = parentApplication.getParentApplication()) != null && !((Object)((Object)parentApplication)).getClass().getName().equals("com.arsdigita.portalserver.PortalSite") && !((Object)((Object)parentApplication)).getClass().getName().equals("com.arsdigita.london.portal.Workspace"));
            Session ssn = SessionManager.getSession();
            ApplicationCollection repositories = parentApplication.getChildApplicationsForType("com.arsdigita.cms.docmgr.Repository");
            repositories.addOrder("title");
            while (repositories.next()) {
                BigDecimal rootID;
                Repository repository = (Repository)repositories.getDomainObject();
                map.put(rootID, this.createNode(state, treeElement, !(rootID = repository.getRoot().getID()).equals(sourceFolderID), rootID, repository.getTitle(), DestinationFolderForm.TYPE_REPOSITORY));
                DataCollection docFolders = ssn.retrieve("com.arsdigita.cms.docmgr.DocFolder");
                DomainCollection dc = new DomainCollection(docFolders);
                dc.addFilter(dc.getFilterFactory().contains("ancestors", "/" + rootID.toString() + "/", false));
                dc.addOrder("ancestors");
                while (dc.next()) {
                    boolean isSelectable;
                    DocFolder folder = (DocFolder)dc.getDomainObject();
                    BigDecimal parentID = folder.getParent().getID();
                    BigDecimal resourceID = folder.getID();
                    s_log.debug((Object)("resource id is " + resourceID.toString()));
                    s_log.debug((Object)("  parent id is " + parentID.toString()));
                    String name = null;
                    name = resourceID.equals(rootID) ? "Documents" : folder.getTitle();
                    Element p = (Element)map.get(parentID);
                    boolean bl = isSelectable = !resourceID.equals(sourceFolderID);
                    if (p == null) continue;
                    map.put(resourceID, this.createNode(state, p, isSelectable, resourceID, name, DestinationFolderForm.TYPE_FOLDER));
                }
                dc.close();
                docFolders.close();
            }
            repositories.close();
        }

        private Element createNode(PageState state, Element parent, boolean makeSelectable, BigDecimal id, String name, String type) {
            Element element = parent.newChildElement("bebop:t_node", "http://www.arsdigita.com/bebop/1.0");
            element.addAttribute("indentStart", "t");
            element.addAttribute("indentClose", "t");
            element.addAttribute("type", type);
            if (makeSelectable) {
                element.addAttribute("resourceID", id.toString());
                element.addAttribute("radioGroup", "t");
                element.addAttribute("radioGroupName", this.getName());
            } else {
                element.addAttribute("radioGroup", "f");
            }
            Label label = new Label(name);
            label.generateXML(state, element);
            return element;
        }
    }
}

