/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.xml.Element;

public class PagingControlContainer
extends BoxPanel {
    public static final String CLASS_PAGING_CONTROL = "pageControlClass";
    public static final String CLASS_SELECTED = "selected";
    public static final String LABEL_PREVIOUS = "< Previous";
    public static final String LABEL_NEXT = "Next >";
    private static final int m_size = 9;
    private final IntegerParameter m_pageNo;
    private final RequestLocal m_maxPages;
    private final int m_itemsPerPage;
    private Label m_prevLabel;
    private ActionLink m_prev;
    private Label m_firstLabel;
    private ActionLink m_first;
    private Label m_separator1 = new Label("...");
    private Label[] m_pageLinksLabel;
    private ActionLink[] m_pageLinks;
    private Label m_separator2 = new Label("...");
    private Label m_nextLabel;
    private ActionLink m_next;
    private Label m_lastLabel;
    private ActionLink m_last;

    public PagingControlContainer(IntegerParameter pageNo, RequestLocal maxPages) {
        this(pageNo, maxPages, 20);
    }

    public PagingControlContainer(IntegerParameter pageNo, RequestLocal maxPages, int itemsPerPage) {
        super(1);
        Label label;
        this.m_pageNo = pageNo;
        this.m_maxPages = maxPages;
        this.m_itemsPerPage = itemsPerPage;
        this.setClassAttr(CLASS_PAGING_CONTROL);
        this.m_prevLabel = new Label(LABEL_PREVIOUS);
        this.add((Component)this.m_prevLabel);
        this.m_prev = new ActionLink(LABEL_PREVIOUS);
        this.m_prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageState ps = ae.getPageState();
                Integer pageNo = (Integer)ps.getValue((ParameterModel)PagingControlContainer.this.m_pageNo);
                int pn = 0;
                if (pageNo != null) {
                    pn = pageNo;
                }
                if (pn > 0) {
                    --pn;
                }
                ps.setValue((ParameterModel)PagingControlContainer.this.m_pageNo, (Object)new Integer(pn));
            }
        });
        this.add((Component)this.m_prev);
        this.m_firstLabel = new Label("1");
        this.m_firstLabel.setClassAttr(CLASS_SELECTED);
        this.add((Component)this.m_firstLabel);
        this.m_first = new ActionLink("1");
        this.m_first.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageState ps = ae.getPageState();
                ps.setValue((ParameterModel)PagingControlContainer.this.m_pageNo, (Object)new Integer(0));
            }
        });
        this.add((Component)this.m_first);
        this.add((Component)this.m_separator1);
        this.m_pageLinksLabel = new Label[9];
        this.m_pageLinks = new ActionLink[9];
        for (int i = 0; i < 9; ++i) {
            this.m_pageLinksLabel[i] = new Label((PrintListener)new PageLinkPrintListener(i));
            this.m_pageLinksLabel[i].setClassAttr(CLASS_SELECTED);
            this.add((Component)this.m_pageLinksLabel[i]);
            label = new Label((PrintListener)new PageLinkPrintListener(i));
            this.m_pageLinks[i] = new ActionLink((Component)label);
            this.m_pageLinks[i].addActionListener((ActionListener)new PageLinkActionListener(i));
            this.add((Component)this.m_pageLinks[i]);
        }
        this.add((Component)this.m_separator2);
        this.m_lastLabel = new Label(new PrintListener(){

            public void prepare(PrintEvent pe) {
                PageState ps = pe.getPageState();
                Label l = (Label)pe.getTarget();
                l.setLabel(String.valueOf(PagingControlContainer.this.m_maxPages.get(ps)), ps);
            }
        });
        this.m_lastLabel.setClassAttr(CLASS_SELECTED);
        this.add((Component)this.m_lastLabel);
        label = new Label(new PrintListener(){

            public void prepare(PrintEvent pe) {
                PageState ps = pe.getPageState();
                Label l = (Label)pe.getTarget();
                l.setLabel(String.valueOf(PagingControlContainer.this.m_maxPages.get(ps)), ps);
            }
        });
        this.m_last = new ActionLink((Component)label);
        this.m_last.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageState ps = ae.getPageState();
                ps.setValue((ParameterModel)PagingControlContainer.this.m_pageNo, (Object)new Integer((Integer)PagingControlContainer.this.m_maxPages.get(ps) - 1));
            }
        });
        this.add((Component)this.m_last);
        this.m_nextLabel = new Label(LABEL_NEXT);
        this.add((Component)this.m_nextLabel);
        this.m_next = new ActionLink(LABEL_NEXT);
        this.m_next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PageState ps = ae.getPageState();
                Integer pageNo = (Integer)ps.getValue((ParameterModel)PagingControlContainer.this.m_pageNo);
                int pn = pageNo == null ? 0 : pageNo;
                ps.setValue((ParameterModel)PagingControlContainer.this.m_pageNo, (Object)new Integer(++pn));
            }
        });
        this.add((Component)this.m_next);
    }

    public int getPageNo(PageState ps) {
        Integer pn = (Integer)ps.getValue((ParameterModel)this.m_pageNo);
        int pageNo = pn == null ? 0 : pn;
        return pageNo;
    }

    public int getMaxPages(PageState ps) {
        Integer mp = (Integer)this.m_maxPages.get(ps);
        int maxPages = mp == null ? 0 : mp;
        return maxPages;
    }

    public int getFirstRowNo(PageState ps) {
        Integer pn = (Integer)ps.getValue((ParameterModel)this.m_pageNo);
        int pageNo = pn == null ? 0 : pn;
        return pageNo * this.m_itemsPerPage + 1;
    }

    public int getLastRowNo(PageState ps) {
        return this.getFirstRowNo(ps) + this.m_itemsPerPage;
    }

    public void generateXML(PageState ps, Element e) {
        int pageNo = this.getPageNo(ps);
        int maxPages = this.getMaxPages(ps);
        this.m_prevLabel.setVisible(ps, pageNo == 0);
        this.m_prev.setVisible(ps, pageNo > 0);
        this.m_firstLabel.setVisible(ps, pageNo == 0);
        this.m_first.setVisible(ps, pageNo > 0);
        this.m_separator1.setVisible(ps, maxPages > 11 ? pageNo > 5 : false);
        for (int i = 0; i < 9; ++i) {
            if (maxPages > i + 2) {
                int pnl = this.calcPageNo(ps, i) - 1;
                this.m_pageLinksLabel[i].setVisible(ps, pnl == pageNo);
                this.m_pageLinks[i].setVisible(ps, pnl != pageNo);
                continue;
            }
            this.m_pageLinksLabel[i].setVisible(ps, false);
            this.m_pageLinks[i].setVisible(ps, false);
        }
        this.m_separator2.setVisible(ps, maxPages > 11 ? pageNo + 1 < maxPages - 4 - 1 : false);
        this.m_lastLabel.setVisible(ps, maxPages > 1 ? pageNo + 1 >= maxPages : false);
        this.m_last.setVisible(ps, maxPages > 1 ? pageNo + 1 < maxPages : false);
        this.m_nextLabel.setVisible(ps, pageNo + 1 >= maxPages);
        this.m_next.setVisible(ps, pageNo + 1 < maxPages);
        super.generateXML(ps, e);
    }

    private int calcPageNo(PageState ps, int pageOffset) {
        int maxPages;
        Integer pn = (Integer)ps.getValue((ParameterModel)this.m_pageNo);
        int pageNo = pn == null ? 0 : pn;
        Integer mp = (Integer)this.m_maxPages.get(ps);
        int n = maxPages = mp == null ? 0 : mp;
        pageNo = maxPages <= 11 || pageNo < 6 ? 2 + pageOffset : (pageNo > maxPages - 6 ? maxPages - 9 + pageOffset : pageNo - 4 + 1 + pageOffset);
        return pageNo;
    }

    class PageLinkActionListener
    implements ActionListener {
        private int m_pageOffset;

        PageLinkActionListener(int pageOffset) {
            this.m_pageOffset = pageOffset;
        }

        public void actionPerformed(ActionEvent ae) {
            PageState ps = ae.getPageState();
            int pageNo = PagingControlContainer.this.calcPageNo(ps, this.m_pageOffset);
            ps.setValue((ParameterModel)PagingControlContainer.this.m_pageNo, (Object)new Integer(pageNo - 1));
        }
    }

    class PageLinkPrintListener
    implements PrintListener {
        private int m_pageOffset;

        PageLinkPrintListener(int pageOffset) {
            this.m_pageOffset = pageOffset;
        }

        public void prepare(PrintEvent pe) {
            PageState ps = pe.getPageState();
            int pageNo = PagingControlContainer.this.calcPageNo(ps, this.m_pageOffset);
            Label l = (Label)pe.getTarget();
            l.setLabel(String.valueOf(pageNo), ps);
        }
    }
}

