/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.docmgr.DocLink;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.RecentUpdatedDocsPortlet;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

class RecentUpdatedDocsPortletRenderer
extends AbstractPortletRenderer
implements DMConstants {
    private RecentUpdatedDocsPortlet m_portlet;

    public RecentUpdatedDocsPortletRenderer(RecentUpdatedDocsPortlet docsPortlet) {
        this.m_portlet = docsPortlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        Application application = this.m_portlet.getParentApplication();
        String fileURL = application.getPath();
        Repository rep = (Repository)application;
        HttpServletRequest req = pageState.getRequest();
        Object[] tableHeaders = new String[]{"File", "Type", "Size", "Author", "Date", ""};
        DataQuery files = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.docmgr.ui.RecentUpdatedDocs");
        files.setParameter("ancestors", (Object)("%/" + rep.getRoot().getID().toString() + "/%"));
        files.setParameter("maxRows", (Object)new Integer(10));
        ArrayList<Object[]> tableDataList = new ArrayList<Object[]>();
        SimpleDateFormat dft = new SimpleDateFormat();
        while (files.next()) {
            Object[] tableRow = new Object[6];
            Resource res = (Resource)DomainObjectFactory.newInstance((OID)new OID((String)files.get("objectType"), files.get("docID")));
            Document document = null;
            DocLink docLink = null;
            boolean isExternalLink = false;
            if (res instanceof DocLink) {
                docLink = (DocLink)res;
                isExternalLink = docLink.isExternal();
                if (!isExternalLink) {
                    document = docLink.getTarget();
                }
            } else {
                document = (Document)res;
            }
            if (isExternalLink) {
                tableRow[0] = new ExternalLink(res.getTitle(), docLink.getExternalURL());
                tableRow[1] = "Link";
                tableRow[2] = "";
                tableRow[3] = "";
                Date date = docLink.getLastModifiedLocal();
                tableRow[4] = date != null ? dft.format(date) : "";
                tableRow[5] = new ExternalLink("download", docLink.getExternalURL());
            } else {
                tableRow[0] = new Link(document.getTitle(), fileURL + "/?" + "d_id" + "=" + document.getID());
                tableRow[1] = document.getPrettyMimeType();
                long fileSize = document.getSize().longValue();
                tableRow[2] = DMUtils.FileSize.formatFileSize(fileSize);
                tableRow[3] = document.getImpliedAuthor();
                Date date = document.getLastModifiedLocal();
                tableRow[4] = date != null ? dft.format(date) : "";
                Link link = new Link("Download", fileURL + "/download/?" + "d_id" + "=" + document.getID().toString());
                link.setClassAttr("downloadLink");
                tableRow[5] = link;
            }
            tableDataList.add(tableRow);
        }
        files.close();
        GridPanel panel = new GridPanel(1);
        this.addResourceLinks(panel, rep);
        if (tableDataList.isEmpty()) {
            panel.add((Component)new Label(REPOSITORY_RECENTDOCS_EMPTY.localize(req).toString()));
            panel.generateXML(pageState, parentElement);
            return;
        }
        Object[][] tableData = (Object[][])tableDataList.toArray((T[])new Object[0][0]);
        Table table = new Table(tableData, tableHeaders);
        panel.add((Component)table, 64);
        panel.generateXML(pageState, parentElement);
    }

    private void addResourceLinks(GridPanel panel, Repository rep) {
        User user = Web.getContext().getUser();
        if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.CREATE, (ACSObject)rep, (Party)user))) {
            return;
        }
        Link addResourceLink = new Link((Component)new Label(ROOT_ADD_RESOURCE_LINK), this.m_portlet.getParentApplication().getPath() + "?" + ROOT_ADD_DOC_PARAM.getName() + "=t");
        addResourceLink.setClassAttr("actionLink");
        panel.add((Component)addResourceLink, 100);
        addResourceLink = new Link((Component)new Label(ROOT_ADD_DOCLINK_LINK), this.m_portlet.getParentApplication().getPath() + "?" + "root_add_doc_link" + "=");
        addResourceLink.setClassAttr("actionLink");
        panel.add((Component)addResourceLink, 100);
    }
}

