/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.authoring.FileFormSection;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import org.apache.log4j.Logger;

public class DocumentPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger(DocumentPropertyForm.class);
    public static final String DESCRIPTION = "description";
    public static final String FILE = "file";
    private FileFormSection m_fileSection;

    public DocumentPropertyForm(ItemSelectionModel itemModel) {
        super("id", itemModel);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label("Description:"));
        StringParameter descriptionParam = new StringParameter(DESCRIPTION);
        TextArea description = new TextArea((ParameterModel)descriptionParam);
        description.setCols(40);
        description.setRows(5);
        this.add((Component)description);
        this.m_fileSection = new FileFormSection(FILE, "File:");
        this.add((Component)this.m_fileSection);
        this.add((Component)new Label(""));
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData d = e.getFormData();
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Document document = (Document)super.initBasicWidgets(fse);
        data.put((Object)DESCRIPTION, (Object)document.getDescription());
        this.m_fileSection.initialize(fse, document.getFile());
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        Document document = (Document)super.processBasicWidgets(fse);
        if (document != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            FileAsset file = this.m_fileSection.process(fse, document.getFile());
            document.setFile(file);
            document.setDescription((String)data.get((Object)DESCRIPTION));
            document.save();
        }
    }
}

