/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpUtils;

public class CWURLFinder
implements URLFinder {
    private String m_base;
    private Map m_params = new HashMap();

    public CWURLFinder(String urlEndingPattern) {
        this.m_base = CWURLFinder.parseQueryString(urlEndingPattern, this.m_params);
    }

    public String find(OID oid, String context) throws NoValidURLException {
        return this.find(oid);
    }

    public String find(OID oid) throws NoValidURLException {
        ACSObject obj;
        try {
            obj = (ACSObject)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException e) {
            throw new NoValidURLException("No such data object: " + oid);
        }
        if (obj instanceof Application) {
            return ((Application)obj).getPrimaryURL();
        }
        Application app = Application.getContainingApplication((ACSObject)obj);
        if (app == null) {
            throw new NoValidURLException("Could not find application instance for " + obj);
        }
        return app.getPrimaryURL() + this.m_base + this.unparseQueryString(oid);
    }

    private String unparseQueryString(OID oid) {
        StringBuffer buf = new StringBuffer(128);
        int sep = 63;
        for (String key : this.m_params.keySet()) {
            Object value = this.m_params.get(key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    CWURLFinder.appendParam(buf, (char)sep, key, this.getValue(oid, values[i]));
                    sep = 38;
                }
                continue;
            }
            if (value == null) continue;
            CWURLFinder.appendParam(buf, (char)sep, key, this.getValue(oid, value.toString()));
            sep = 38;
        }
        return buf.toString();
    }

    private String getValue(OID oid, String val) {
        if (val.equals(":oid")) {
            return oid.toString();
        }
        if (val.charAt(0) == ':') {
            return oid.get(val.substring(1)).toString();
        }
        return val;
    }

    private static String parseQueryString(String url, Map params) {
        int qmark = url.indexOf(63);
        if (qmark < 0) {
            return url;
        }
        String base = url.substring(0, qmark);
        String query = url.substring(qmark + 1);
        params.putAll(HttpUtils.parseQueryString((String)query));
        return base;
    }

    private static void appendParam(StringBuffer buf, char sep, String key, String value) {
        buf.append(sep).append(URLEncoder.encode(key)).append('=').append(URLEncoder.encode(value));
    }
}

