/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.ResourceSetup;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.AgentPortlet;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.portalserver.ApplicationDirectoryPortlet;
import com.arsdigita.portalserver.PortalNavigatorPortlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSummaryPortlet;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.SubPortalTab;
import com.arsdigita.portalserver.Theme;
import com.arsdigita.portalserver.personal.MyPortalsPortlet;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Loader.this.loadPortalSiteApplicationType();
                Loader.this.buildDefaultThemes();
                Loader.this.setupAdminPortal();
                Loader.this.loadPortalTabApplicationType();
                Loader.this.loadSubPortalTabApplicationType();
                Loader.this.loadPortalSiteAdminApplicationType();
                Loader.this.setupPortalSiteAdminInstance();
                Loader.this.loadPortalCreatorApplicationType();
                Loader.this.loadPortalSitemapApplicationType();
                Loader.this.setupPortalCreatorInstance();
                Loader.this.setupPortalSitemapInstance();
                Loader.this.loadPersonalPortalCreatorApplicationType();
                Loader.this.setupPersonalPortalCreatorInstance();
                Loader.this.loadPersonalPortalApplicationType();
                Loader.this.setupMyPortalsPortlet();
                Loader.this.setupAgentPortlet();
                Loader.this.setupApplicationDirectoryPortlet();
                Loader.this.setupPortalNavigatorPortlet();
                Loader.this.setupPortalSummaryPortlet();
            }
        }.run();
        s_log.info((Object)"Done");
    }

    private void loadPortalSiteApplicationType() {
        ApplicationType type = new ApplicationType("Portal Site", "com.arsdigita.workspace.Workspace");
        type.setDescription("A Portal Site is a center for content aggregation. It usuallyhas its own set of applications, such as a discussion forum and content items, as well as a list of participants.");
        type.save();
    }

    private void loadPortalTabApplicationType() {
        ResourceSetup setup = new ResourceSetup(s_log);
        setup.setTitle("PortalTab");
        setup.setResourceObjectType("com.arsdigita.workspace.WorkspaceTab");
        setup.setDescription("A Portal Tab!");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalTab(dataObject);
            }
        });
        setup.run();
    }

    private void loadSubPortalTabApplicationType() {
        ResourceSetup setup = new ResourceSetup(s_log);
        setup.setTitle("SubPortalTab");
        setup.setResourceObjectType("com.arsdigita.workspace.SubWorkspaceTab");
        setup.setDescription("A SubPortal Tab!");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new SubPortalTab(dataObject);
            }
        });
        setup.run();
    }

    private void loadPortalSiteAdminApplicationType() {
        ApplicationType type = new ApplicationType("Portal Admin", "com.arsdigita.admin.CWAdmin");
        type.setDescription("Displays common administration tasks.");
        type.save();
    }

    private void loadPortalCreatorApplicationType() {
        ApplicationType type = new ApplicationType("Portal Creator", "com.arsdigita.workspace.ui.WorkspaceCreator");
        type.setDescription("Creates portals.");
        type.save();
    }

    private void loadPortalSitemapApplicationType() {
        ApplicationType type = new ApplicationType("Portal SiteMap", "com.arsdigita.workspace.ui.PortalSiteMap");
        type.setDescription("Displays and manages Portals.");
        type.save();
    }

    private void loadPersonalPortalCreatorApplicationType() {
        ApplicationType type = new ApplicationType("Personal Portal Creator", "com.arsdigita.workspace.personal.PersonalWorkspaceCreator");
        type.setDescription("Displays and manages Portals.");
        type.save();
    }

    private void loadPersonalPortalApplicationType() {
        ApplicationType type = new ApplicationType("Personal Portal", "com.arsdigita.workspace.personal.PersonalWorkspace");
        type.setDescription("A portal for an individual.");
        type.save();
    }

    private void setupAdminPortal() {
        PortalSite ps = PortalSite.createPortalSite("administration", "Administration", null);
        ps.setMission("Administration Portal");
        ps.save();
    }

    private void setupPortalSiteAdminInstance() {
        if (!Application.isInstalled((String)"com.arsdigita.admin.CWAdmin", (String)"/portal-admin/")) {
            s_log.info((Object)"There is no Portal Admin application instance on /portal-admin/.  Installing now.");
            Application app = Application.createApplication((String)"com.arsdigita.admin.CWAdmin", (String)"portal-admin", (String)"Site Administration", null);
            app.save();
            s_log.info((Object)"Done installing Portal Admin on /portal-admin/.");
        }
    }

    private void setupPortalCreatorInstance() {
        if (!Application.isInstalled((String)"com.arsdigita.workspace.ui.WorkspaceCreator", (String)"/portal-admin/portal-create/")) {
            Application admin = Application.retrieveApplicationForPath((String)"/portal-admin/");
            if (admin == null) {
                s_log.warn((Object)"There is no application at /portal-admin/ so I can't install the portal create application.");
                return;
            }
            s_log.info((Object)"There is no Portal Creator application instance on /user-profile/.  Installing now.");
            Application app = Application.createApplication((String)"com.arsdigita.workspace.ui.WorkspaceCreator", (String)"portal-create", (String)"Create Top-Level Portals", (Application)admin);
            app.setDescription("Create top-level portals.");
            app.save();
            s_log.info((Object)"Done installing Portal Creator on /portal-admin/portal-create/.");
        }
    }

    private void setupPortalSitemapInstance() {
        if (!Application.isInstalled((String)"com.arsdigita.workspace.ui.PortalSiteMap", (String)"/portal-admin/portal-sitemap/")) {
            Application admin = Application.retrieveApplicationForPath((String)"/portal-admin/");
            if (admin == null) {
                s_log.warn((Object)"There is no application at /portal-admin/ so I can't install the portal sitemap application.");
                return;
            }
            s_log.info((Object)"There is no Portal Site Map application instance on /portal-admin/.  Installing now.");
            Application app = Application.createApplication((String)"com.arsdigita.workspace.ui.PortalSiteMap", (String)"portal-sitemap", (String)"Portal Site Map", (Application)admin);
            app.setDescription("Portal Site Map");
            app.save();
            s_log.info((Object)"Done installing Portal Site Map on /portal-admin/portal-sitemap/.");
        }
    }

    private void setupPersonalPortalCreatorInstance() {
        boolean creatorInstalled = Application.isInstalled((String)"com.arsdigita.workspace.personal.PersonalWorkspaceCreator", (String)"/personal-portal/");
        if (!creatorInstalled) {
            Application creatorApp = Application.createApplication((String)"com.arsdigita.workspace.personal.PersonalWorkspaceCreator", (String)"personal-portal", (String)"Personal Portal Creator", null);
            creatorApp.save();
        }
    }

    private void setupAgentPortlet() {
        PortletSetup setup = new PortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.portal.AgentPortlet");
        setup.setTitle("Agent");
        setup.setDescription("Acts as agent or proxy for another portlet.");
        setup.setProfile("wide");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new AgentPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupApplicationDirectoryPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.ApplicationDirectoryPortlet");
        setup.setTitle("Application Directory");
        setup.setDescription("Provides links to the workspace's applications.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new ApplicationDirectoryPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupMyPortalsPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.personal.MyWorkspacesPortlet");
        setup.setTitle("My Portals");
        setup.setDescription("Displays links to portals to which you belong.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new MyPortalsPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupPortalNavigatorPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.WorkspaceNavigatorPortlet");
        setup.setTitle("Portal Navigator");
        setup.setDescription("Provides links to portal associated with the current portal.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalNavigatorPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupPortalSummaryPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.WorkspaceSummaryPortlet");
        setup.setTitle("Portal Summary");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSummaryPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void buildDefaultThemes() {
        Theme theme0 = new Theme("Red Hat");
        theme0.setDescription("A cool corporate theme");
        theme0.setContextBarColor("#E1E1E1");
        theme0.setContextBarTextColor("#3F3F3F");
        theme0.setActiveTabColor("#a21e1e");
        theme0.setInactiveTabColor("#dddddd");
        theme0.setInactiveTabTextColor("#555555");
        theme0.setActiveTabTextColor("#ffffff");
        theme0.setTopRuleColor("#a21e1e");
        theme0.setBottomRuleColor("#a21e1e");
        theme0.setPortletHeaderColor("#a21e1e");
        theme0.setPortletIconColor("#a21e1e");
        theme0.setPortletHeaderTextColor("#ffffff");
        theme0.setPageBGColor("#ffffff");
        theme0.setBodyTextColor("#000000");
        theme0.setNarrowBGColor("#dddddd");
        theme0.save();
        Theme theme2 = new Theme("Bright Day");
        theme2.setDescription("A sunny, cloudless sky");
        theme2.setContextBarColor("#003366");
        theme2.setContextBarTextColor("#FFFFFF");
        theme2.setActiveTabColor("#93bee2");
        theme2.setInactiveTabColor("#d8e8f5");
        theme2.setInactiveTabTextColor("#000000");
        theme2.setActiveTabTextColor("#000000");
        theme2.setTopRuleColor("#93bee2");
        theme2.setBottomRuleColor("#93bee2");
        theme2.setPortletHeaderColor("#cccccc");
        theme2.setPortletIconColor("#cccccc");
        theme2.setPortletHeaderTextColor("#000000");
        theme2.setPageBGColor("#ffffff");
        theme2.setPageBGImage("");
        theme2.setNarrowBGColor("#dddddd");
        theme2.setBodyTextColor("#000000");
        theme2.save();
        Theme theme3 = new Theme("Harvest");
        theme3.setDescription("High Heat");
        theme3.setContextBarColor("#ff9966");
        theme3.setContextBarTextColor("#ffffff");
        theme3.setActiveTabColor("#ff9966");
        theme3.setInactiveTabColor("#ffcc99");
        theme3.setInactiveTabTextColor("#000000");
        theme3.setActiveTabTextColor("#000000");
        theme3.setTopRuleColor("#ff9966");
        theme3.setBottomRuleColor("#ff9966");
        theme3.setPortletHeaderColor("#ff9966");
        theme3.setPortletIconColor("#ff9966");
        theme3.setPortletHeaderTextColor("#000000");
        theme3.setPageBGColor("#ffffff");
        theme3.setPageBGImage("");
        theme3.setNarrowBGColor("#ffffcc");
        theme3.setBodyTextColor("#000000");
        theme3.save();
        Theme theme4 = new Theme("Desert");
        theme4.setDescription("High Heat");
        theme4.setContextBarColor("#cccc99");
        theme4.setContextBarTextColor("#FFFFFF");
        theme4.setActiveTabColor("#cccc99");
        theme4.setInactiveTabColor("#ededca");
        theme4.setInactiveTabTextColor("#000000");
        theme4.setActiveTabTextColor("#000000");
        theme4.setTopRuleColor("#cccc99");
        theme4.setBottomRuleColor("#cccc99");
        theme4.setPortletHeaderColor("#cccc99");
        theme4.setPortletIconColor("#cccc99");
        theme4.setPortletHeaderTextColor("#000000");
        theme4.setPageBGColor("#ffffff");
        theme4.setPageBGImage("");
        theme4.setNarrowBGColor("#ffffcc");
        theme4.setBodyTextColor("#000000");
        theme4.save();
        Theme theme5 = new Theme("Stars and Bars");
        theme5.setDescription("Patriotic");
        theme5.setContextBarColor("#cc0000");
        theme5.setContextBarTextColor("#FFFFFF");
        theme5.setActiveTabColor("#cc0000");
        theme5.setInactiveTabColor("#ffffff");
        theme5.setInactiveTabTextColor("#000000");
        theme5.setActiveTabTextColor("#ffffff");
        theme5.setTopRuleColor("#cc0000");
        theme5.setBottomRuleColor("#cc0000");
        theme5.setPortletHeaderColor("#cc0000");
        theme5.setPortletIconColor("#cc0000");
        theme5.setPortletHeaderTextColor("#ffffff");
        theme5.setPageBGColor("#ffffff");
        theme5.setPageBGImage("/assets/cw/backgrounds/stars.gif");
        theme5.setNarrowBGColor("#eeeeee");
        theme5.setBodyTextColor("#000000");
        theme5.save();
    }
}

