/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.portalserver.ui.admin.PortalSiteMapPanel;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.xml.Document;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PortalSiteMapServlet
extends BaseApplicationServlet {
    private static final Logger s_log = Logger.getLogger(PortalSiteMapServlet.class);
    private static final String XSL_HOOK = "portal-sitemap";
    private static final PresentationManager s_presManager = Templating.getPresentationManager();
    private static Page s_indexPage = PortalSiteMapServlet.buildSiteMapPage();

    public void doInit() throws ServletException {
        s_log.debug((Object)"PortalSiteMapServlet doInit() initialization executing!");
    }

    public void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        s_log.debug((Object)("PortalSiteMApServlet.doService called for request '" + sreq.getRequestURI() + "'"));
        String pathInfo = sreq.getPathInfo();
        Assert.exists((Object)pathInfo, (String)"String pathInfo");
        if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        Document doc = null;
        doc = s_indexPage.buildDocument(sreq, sresp);
        s_presManager.servePage(doc, sreq, sresp);
    }

    static Page buildSiteMapPage() {
        Page page = PageFactory.buildPage((String)XSL_HOOK, (String)"Portal Site Map");
        PortalSiteMapPanel sitemapPanel = new PortalSiteMapPanel(page);
        page.add((Component)sitemapPanel);
        page.addRequestListener((RequestListener)new UserAuthenticationListener());
        page.lock();
        return page;
    }
}

