/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform;

import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class FreeformContentItem
extends ContentPage {
    public static final String HTML = "Text/Html";
    public static final String WML = "Text/WirelessHtml";
    public static final String ADOBE = "Adobe/pdf";
    public static final String ASSETS = "assets";
    public static final String MIMETYPE = "mimetype";
    public static final String RANK = "rank";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.cms.freeform.FreeformContentItem";
    private static final String ID_NAME = "itemId";
    private static final String QUERY_NAME = "com.arsdigita.london.cms.freeform.FreeformGetAssetAttributes";
    private static final String ASSET_ID = "id";
    private static final String ASSET_NAME = "name";
    private static final String ASSET_DESC = "description";
    private static final String ASSET_RANK = "rank";

    public FreeformContentItem() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public FreeformContentItem(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public FreeformContentItem(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public FreeformContentItem(DataObject obj) {
        super(obj);
    }

    public FreeformContentItem(String type) {
        super(type);
    }

    public Asset getOneAsset(String mimeType, String rank) {
        Asset asset = null;
        int count = Integer.parseInt(rank);
        DataAssociationCursor dac = ((DataAssociation)this.get(ASSETS)).cursor();
        dac.addEqualsFilter("assets.asset.mimeType.mimeType", (Object)mimeType);
        while (dac.next()) {
            if (count == 0) {
                Link link = new Link(dac.getDataObject());
                asset = link.getAsset();
                break;
            }
            --count;
        }
        dac.close();
        return asset;
    }

    public void addAsset(Asset oneAsset, Integer rank) {
        if (rank == 0) {
            DataQuery query = SessionManager.getSession().retrieveQuery(QUERY_NAME);
            query.setParameter(ID_NAME, (Object)this.getID());
            query.addOrder("rank desc");
            rank = !query.next() ? new Integer(1) : new Integer(((BigDecimal)query.get("rank")).intValue() + 1);
            query.close();
        }
        Link link = Link.create(oneAsset, rank);
        DataAssociation da = (DataAssociation)this.get(ASSETS);
        link.addToAssociation(da);
        da.close();
    }

    public void removeAsset(Asset oneAsset) {
        DataAssociationCursor da = ((DataAssociation)this.get(ASSETS)).cursor();
        da.addEqualsFilter("assets.asset.id", (Object)oneAsset.getID());
        if (da.next()) {
            da.remove();
        }
        da.close();
    }

    public String getRank(Asset oneAsset) {
        DataAssociationCursor da = ((DataAssociation)this.get(ASSETS)).cursor();
        da.addEqualsFilter("assets.asset.id", (Object)oneAsset.getID());
        Integer rank = null;
        if (da.next()) {
            Link link = new Link(da.getDataObject());
            rank = link.getRank();
        }
        return rank == null ? null : rank.toString();
    }

    public void changeAssetRank(BigDecimal assetId, boolean moveUp) {
        BigDecimal prevID = null;
        BigDecimal currID = null;
        BigDecimal prevRank = null;
        BigDecimal currRank = null;
        DataQuery query = SessionManager.getSession().retrieveQuery(QUERY_NAME);
        query.setParameter(ID_NAME, (Object)this.getID());
        query.addOrder("rank asc");
        while (query.next()) {
            prevID = currID;
            prevRank = currRank;
            currID = (BigDecimal)query.get(ASSET_ID);
            currRank = (BigDecimal)query.get("rank");
            if ((!assetId.equals(currID) || !moveUp) && (!assetId.equals(prevID) || moveUp)) continue;
            query.close();
            Session ssn = SessionManager.getSession();
            DataOperation op = ssn.retrieveDataOperation("com.arsdigita.london.cms.freeform.updateAssetRank");
            op.setParameter(ID_NAME, (Object)this.getID());
            op.setParameter("assetId", (Object)prevID);
            op.setParameter("rank", (Object)currRank);
            op.execute();
            op.setParameter("assetId", (Object)currID);
            op.setParameter("rank", (Object)prevRank);
            op.execute();
            break;
        }
    }

    private static class Link
    extends DomainObject {
        private static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.cms.freeform.FreeformContentItemAsset";
        private static final String ITEM_ID = "itemID";
        private static final String ASSET_ID = "assetID";
        private static final String ASSET = "asset";
        private static final String RANK = "rank";

        private Link() {
            super(BASE_DATA_OBJECT_TYPE);
        }

        public Link(DataObject obj) {
            super(obj);
        }

        public static Link create(Asset asset, Integer rank) {
            Link link = new Link();
            link.set(ASSET, asset);
            link.set("rank", rank);
            return link;
        }

        public Asset getAsset() {
            return (Asset)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(ASSET)));
        }

        public Integer getRank() {
            return (Integer)this.get("rank");
        }
    }
}

