/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.london.cms.freeform.FreeformContentItem;
import com.arsdigita.london.cms.freeform.ui.AssetTableCellRenderer;
import com.arsdigita.london.cms.freeform.ui.PaginationTable;
import com.arsdigita.london.cms.freeform.ui.PaginationTableModelBuilder;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class FreeformAssetTable
extends PaginationTable {
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_DESC = "Description";
    public static final String COLUMN_TYPE = "Type";
    public static final String COLUMN_MOVEUP = "Up";
    public static final String COLUMN_MOVEDOWN = "Down";
    private static final String ID_NAME = "itemId";
    private static final String QUERY_NAME = "com.arsdigita.london.cms.freeform.FreeformGetAssetAttributes";
    private static final String ASSET_ID = "id";
    private static final String ASSET_NAME = "name";
    private static final String ASSET_DESC = "description";
    private static final String ASSET_TYPE = "mimeType";
    private static final String ASSET_RANK = "rank";
    private ItemSelectionModel m_itemModel;

    public FreeformAssetTable(ItemSelectionModel itemModel) {
        super(new FreeformAssetTMB(itemModel));
        ((FreeformAssetTMB)this.getPaginationModelBuilder()).setAssetTable(this);
        this.m_itemModel = itemModel;
        TableColumnModel model = this.getColumnModel();
        model.add(new TableColumn(0, (Object)COLUMN_NAME));
        model.add(new TableColumn(1, (Object)COLUMN_DESC));
        model.add(new TableColumn(2, (Object)COLUMN_TYPE));
        model.add(new TableColumn(3, (Object)COLUMN_MOVEUP));
        model.add(new TableColumn(4, (Object)COLUMN_MOVEDOWN));
        model.get(0).setCellRenderer((TableCellRenderer)new AssetTableCellRenderer(true));
        model.get(3).setCellRenderer((TableCellRenderer)new AssetTableCellRenderer(true));
        model.get(4).setCellRenderer((TableCellRenderer)new AssetTableCellRenderer(true));
        this.addTableActionListener(new TableActionListener(){

            public void cellSelected(TableActionEvent event) {
                FreeformContentItem item = (FreeformContentItem)FreeformAssetTable.this.m_itemModel.getSelectedObject(event.getPageState());
                TableColumn tc = FreeformAssetTable.this.getColumnModel().get(event.getColumn().intValue());
                String columnName = (String)tc.getHeaderValue();
                if (FreeformAssetTable.COLUMN_MOVEUP.equals(columnName)) {
                    item.changeAssetRank(new BigDecimal((String)event.getRowKey()), true);
                } else if (FreeformAssetTable.COLUMN_MOVEDOWN.equals(columnName)) {
                    item.changeAssetRank(new BigDecimal((String)event.getRowKey()), false);
                }
            }

            public void headSelected(TableActionEvent event) {
            }
        });
    }

    private static class FreeformAssetTM
    implements TableModel {
        private TableColumnModel m_columnModel;
        private PageState m_state;
        private DataQuery m_query;
        private BigDecimal m_id = null;
        private String m_name = null;
        private String m_desc = null;
        private String m_type = null;
        private int m_pageNum;
        private int m_pageSize;
        private int m_totalSize;
        boolean m_isFirstPage;
        boolean m_isLastPage;
        private long m_valueCounter;

        public FreeformAssetTM(PaginationTable table, PageState state, DataQuery query) {
            this.m_columnModel = table.getColumnModel();
            this.m_state = state;
            this.m_query = query;
            Paginator pgntr = table.getPaginator();
            this.m_pageNum = pgntr.getSelectedPageNum(state);
            this.m_pageSize = pgntr.getPageSize(state);
            this.m_totalSize = table.getPaginationModelBuilder().getTotalSize(pgntr, state);
            this.m_isFirstPage = this.m_pageNum == 1;
            this.m_isLastPage = this.m_pageNum * this.m_pageSize > this.m_totalSize;
            this.m_valueCounter = 0L;
        }

        public int getColumnCount() {
            return this.m_columnModel.size();
        }

        public boolean nextRow() {
            if (this.m_query != null && this.m_query.next()) {
                this.m_id = (BigDecimal)this.m_query.get(FreeformAssetTable.ASSET_ID);
                this.m_name = (String)this.m_query.get(FreeformAssetTable.ASSET_NAME);
                this.m_desc = (String)this.m_query.get(FreeformAssetTable.ASSET_DESC);
                this.m_type = (String)this.m_query.get(FreeformAssetTable.ASSET_TYPE);
                ++this.m_valueCounter;
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            if (this.m_columnModel == null) {
                return null;
            }
            TableColumn tc = this.m_columnModel.get(columnIndex);
            String columnName = (String)tc.getHeaderValue();
            if (FreeformAssetTable.COLUMN_NAME.equals(columnName)) {
                return this.m_name;
            }
            if (FreeformAssetTable.COLUMN_DESC.equals(columnName)) {
                return this.m_desc;
            }
            if (FreeformAssetTable.COLUMN_TYPE.equals(columnName)) {
                if (this.m_type == null) {
                    return "unknown";
                }
                return this.m_type;
            }
            if (FreeformAssetTable.COLUMN_MOVEUP.equals(columnName)) {
                return this.m_valueCounter == 1L && this.m_pageNum == 1 ? null : "^";
            }
            if (FreeformAssetTable.COLUMN_MOVEDOWN.equals(columnName)) {
                return (long)((this.m_pageNum - 1) * this.m_pageSize) + this.m_valueCounter == (long)this.m_totalSize ? null : "v";
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_id;
        }
    }

    private static class FreeformAssetTMB
    extends PaginationTableModelBuilder {
        private ItemSelectionModel m_itemModel;
        private FreeformAssetTable m_table;

        public FreeformAssetTMB(ItemSelectionModel itemModel) {
            this.m_itemModel = itemModel;
        }

        public void setAssetTable(FreeformAssetTable table) {
            this.m_table = table;
        }

        public boolean isVisible(PageState ps) {
            return this.m_table.isVisible(ps);
        }

        @Override
        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            Paginator pgntr = ((PaginationTable)table).getPaginator();
            DataQuery query = this.getFilteredDataQuery(pgntr, state);
            return new FreeformAssetTM((PaginationTable)table, state, query);
        }

        @Override
        public DataQuery makeDataQuery(Paginator pgntr, PageState state) {
            FreeformContentItem item = (FreeformContentItem)this.m_itemModel.getSelectedObject(state);
            DataQuery query = SessionManager.getSession().retrieveQuery(FreeformAssetTable.QUERY_NAME);
            query.setParameter(FreeformAssetTable.ID_NAME, (Object)item.getID());
            query.addOrder(FreeformAssetTable.ASSET_RANK);
            return query;
        }
    }
}

