/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks;

import com.arsdigita.bookmarks.Bookmarks;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                ApplicationType bmrkAppType = Loader.this.loadBookmarksApp();
                Loader.this.loadBookmarksPortletType(bmrkAppType);
                Loader.setupDefaultBookmarkApplicationInstance();
            }
        }.run();
    }

    private ApplicationType loadBookmarksApp() {
        ApplicationType type = new ApplicationType("Bookmarks", "com.arsdigita.workspace.BookmarkApplication");
        type.setDescription("Bookmarks for a Portal");
        type.save();
        return type;
    }

    private void loadBookmarksPortletType(ApplicationType bmrkAppType) {
        AppPortletType type = AppPortletType.createAppPortletType((String)"Portal Bookmarks", (String)"narrow", (String)"com.arsdigita.workspace.BookmarkPortlet");
        type.setProviderApplicationType(bmrkAppType);
        type.setDescription("Displays bookmarks for this portal.");
    }

    public static void setupDefaultBookmarkApplicationInstance() {
        s_log.debug((Object)"Creating BookmarkApplication instance ...");
        Application parent = Application.retrieveApplicationForPath((String)"/admin/");
        Bookmarks app = Bookmarks.create("bookmarks", "Bookmarks", parent);
        s_log.debug((Object)"Bookmarks instance  created.");
    }
}

