/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.category;

import com.arsdigita.categorization.Category;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.OID;
import com.arsdigita.rssfeed.RSSChannel;
import com.arsdigita.rssfeed.RSSImage;
import com.arsdigita.rssfeed.RSSItem;
import com.arsdigita.rssfeed.RSSItemCollection;
import com.arsdigita.search.intermedia.Searchable;
import com.arsdigita.util.Assert;

public class CategoryChannel
implements RSSChannel {
    private RSSImage m_image;
    private Category m_category;

    public CategoryChannel(Category category, RSSImage image) {
        this.m_image = image;
        this.m_category = category;
    }

    @Override
    public String getTitle() {
        return this.m_category.getDisplayName();
    }

    @Override
    public String getLink() {
        return URLService.locate((OID)this.m_category.getOID());
    }

    @Override
    public String getDescription() {
        return this.m_category.getDescription();
    }

    @Override
    public RSSImage getImage() {
        return this.m_image;
    }

    @Override
    public RSSItemCollection getItems() {
        return new CategoryItemCollection((ACSObjectCollection)this.m_category.getObjects("com.arsdigita.kernel.ACSObject"));
    }

    private class CategoryItem
    implements RSSItem {
        private ACSObject m_object;

        public CategoryItem(ACSObject object) {
            this.m_object = object;
        }

        @Override
        public String getTitle() {
            return this.m_object.getDisplayName();
        }

        @Override
        public String getLink() {
            return URLService.locate((OID)this.m_object.getOID());
        }

        @Override
        public String getDescription() {
            if (this.m_object instanceof Searchable) {
                return ((Searchable)this.m_object).getSearchSummary();
            }
            return null;
        }
    }

    private class CategoryItemCollection
    implements RSSItemCollection {
        private ACSObjectCollection m_objects;
        private ACSObject m_object;

        public CategoryItemCollection(ACSObjectCollection objects) {
            this.m_objects = objects;
            this.m_object = null;
        }

        @Override
        public boolean next() {
            if (this.m_objects.next()) {
                this.m_object = this.m_objects.getACSObject();
                return true;
            }
            this.m_object = null;
            return false;
        }

        @Override
        public RSSItem getItem() {
            Assert.exists((Object)this.m_object, ACSObject.class);
            return new CategoryItem(this.m_object);
        }
    }
}

