/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.rssfeed.Feed;
import com.arsdigita.rssfeed.ui.admin.FeedSelectionModel;

public abstract class FeedForm
extends Form {
    private TextField m_title;
    private TextArea m_desc;
    private boolean m_acsj;
    private SaveCancelSection m_buttons;
    private FeedSelectionModel m_feed;

    public FeedForm(String name, boolean acsj, FeedSelectionModel feed) {
        super(name);
        this.m_acsj = acsj;
        this.m_feed = feed;
        this.m_buttons = new SaveCancelSection();
        this.addWidgets(name);
        this.add((Component)new FormErrorDisplay((Form)this));
        this.add((Component)this.m_buttons, 64);
        this.addProcessListener(new FeedFormProcessListener());
        this.addValidationListener(new FeedFormValidationListener());
        this.addInitListener(new FeedFormInitListener());
    }

    protected void addWidgets(String name) {
        this.m_title = new TextField((ParameterModel)new StringParameter(name + "-title"));
        this.m_title.setSize(30);
        this.m_desc = new TextArea((ParameterModel)new StringParameter(name + "-desc"));
        this.m_desc.setRows(2);
        this.m_desc.setCols(50);
        this.add((Component)new Label("Title:"));
        this.add((Component)this.m_title);
        this.add((Component)new Label("Description"));
        this.add((Component)this.m_desc);
    }

    public Feed getSelectedFeed(PageState state) {
        if (this.m_feed.isSelected(state)) {
            return this.m_feed.getSelectedFeed(state);
        }
        return null;
    }

    protected abstract String getURL(PageState var1);

    protected abstract void setURL(PageState var1, String var2);

    private class FeedFormProcessListener
    implements FormProcessListener {
        private FeedFormProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (FeedForm.this.m_buttons.getSaveButton().isSelected(state)) {
                if (FeedForm.this.m_feed.isSelected(state)) {
                    Feed feed = FeedForm.this.m_feed.getSelectedFeed(state);
                    feed.setTitle((String)FeedForm.this.m_title.getValue(state));
                    feed.setDescription((String)FeedForm.this.m_desc.getValue(state));
                    feed.setURL(FeedForm.this.getURL(state));
                    feed.save();
                } else {
                    Feed feed = Feed.create(FeedForm.this.getURL(state), (String)FeedForm.this.m_title.getValue(state), (String)FeedForm.this.m_desc.getValue(state), FeedForm.this.m_acsj);
                    feed.save();
                }
            }
            FeedForm.this.m_title.setValue(state, null);
            FeedForm.this.m_desc.setValue(state, null);
            FeedForm.this.setURL(state, null);
            FeedForm.this.m_feed.clearSelection(state);
        }
    }

    private class FeedFormValidationListener
    implements FormValidationListener {
        private FeedFormValidationListener() {
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            try {
                String url = FeedForm.this.getURL(state);
                Feed feed = Feed.retrieve(url);
                if (FeedForm.this.m_feed.isSelected(state) && FeedForm.this.m_feed.getSelectedKey(state).equals(feed.getID())) {
                    return;
                }
                throw new FormProcessException("A feed already exists for that URL");
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
    }

    private class FeedFormInitListener
    implements FormInitListener {
        private FeedFormInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (FeedForm.this.m_feed.isSelected(state)) {
                Feed feed = FeedForm.this.m_feed.getSelectedFeed(state);
                FeedForm.this.m_title.setValue(state, (Object)feed.getTitle());
                FeedForm.this.m_desc.setValue(state, (Object)feed.getDescription());
                FeedForm.this.setURL(state, feed.getURL());
            } else {
                FeedForm.this.m_title.setValue(state, null);
                FeedForm.this.m_desc.setValue(state, null);
                FeedForm.this.setURL(state, null);
            }
        }
    }
}

