/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.rssfeed.Feed;
import com.arsdigita.rssfeed.FeedCollection;
import com.arsdigita.rssfeed.ui.admin.FeedSelectionModel;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;

public class FeedsTable
extends Table {
    private FeedSelectionModel m_feed;

    public FeedsTable(FeedSelectionModel feed, boolean acsj) {
        super((TableModelBuilder)new FeedsTableModelBuilder(acsj), (Object[])new String[]{"Title", "Description", "", ""});
        this.m_feed = feed;
        this.setRowSelectionModel((SingleSelectionModel)this.m_feed);
        this.setDefaultCellRenderer(new FeedsTableRenderer());
        this.addTableActionListener(new FeedsTableActionListener());
    }

    private class FeedsTableActionListener
    implements TableActionListener {
        private FeedsTableActionListener() {
        }

        public void cellSelected(TableActionEvent e) {
            if (e.getColumn() == 3) {
                Feed feed = FeedsTable.this.m_feed.getSelectedFeed(e.getPageState());
                feed.delete();
                FeedsTable.this.getRowSelectionModel().clearSelection(e.getPageState());
            }
        }

        public void headSelected(TableActionEvent e) {
        }
    }

    private static class FeedsTableRenderer
    implements TableCellRenderer {
        private FeedsTableRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Feed feed = (Feed)((Object)value);
            if (column == 0) {
                return new ExternalLink((Component)(isSelected ? new Label(feed.getTitle(), "b") : new Label(feed.getTitle())), feed.getURL());
            }
            if (column == 1) {
                return new Label(feed.getDescription());
            }
            if (column == 2) {
                return new ControlLink((Component)new Label("[edit]"));
            }
            if (column == 3) {
                return new ControlLink((Component)new Label("[delete]"));
            }
            throw new UncheckedWrapperException("Column out of bounds " + column);
        }
    }

    public static class FeedsTableModel
    implements TableModel {
        private FeedCollection m_feeds;

        public FeedsTableModel(FeedCollection feeds) {
            this.m_feeds = feeds;
        }

        public boolean nextRow() {
            return this.m_feeds.next();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getElementAt(int columnIndex) {
            return this.m_feeds.getFeed();
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_feeds.getFeed().getID();
        }
    }

    public static class FeedsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private boolean m_acsj;

        public FeedsTableModelBuilder(boolean acsj) {
            this.m_acsj = acsj;
        }

        public TableModel makeModel(Table t, PageState s) {
            FeedCollection feeds = Feed.retrieveAll();
            feeds.filterACSJFeeds(this.m_acsj);
            return new FeedsTableModel(feeds);
        }
    }
}

