/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.SimpleOrganization;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.xml.Element;

public class SimpleOrganizationExtraXmlGenerator
implements ExtraXMLGenerator {
    private boolean listMode;

    public void generateXML(ContentItem item, Element element, PageState state) {
        if (!(item instanceof SimpleOrganization)) {
            throw new IllegalArgumentException("The SimpleOrganizationExtraXMLGenerator can only process instancesof SimpleOrganization.");
        }
        SimpleOrganization organization = (SimpleOrganization)item;
        GenericOrganizationalUnitContactCollection contacts = organization.getContacts();
        Element contactsElem = element.newChildElement("contacts");
        while (contacts.next()) {
            GenericContact contact = contacts.getContact(GlobalizationHelper.getNegotiatedLocale().getLanguage());
            this.generateContactXml(contactsElem, contact, contacts.getContactType(), state);
        }
    }

    private void generateContactXml(Element contactsElem, GenericContact contact, String contactType, PageState state) {
        XmlGenerator generator = new XmlGenerator((ContentItem)contact);
        generator.setItemElemName("contact", "");
        generator.addItemAttribute("contactType", contactType);
        generator.generateXML(state, contactsElem, "");
    }

    public void addGlobalStateParams(Page page) {
    }

    public void setListMode(boolean listMode) {
        this.listMode = listMode;
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        public ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

