/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLValidationListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.IsoCountry;
import com.arsdigita.cms.contenttypes.SimpleAddress;
import com.arsdigita.cms.contenttypes.ui.SimpleAddressPropertiesStep;
import com.arsdigita.cms.contenttypes.util.SimpleAddressGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.domain.DomainCollection;
import org.apache.log4j.Logger;

public class SimpleAddressPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(SimpleAddressPropertyForm.class);
    private SimpleAddressPropertiesStep m_step;
    public static final String ADDRESS = "address";
    public static final String ISO_COUNTRY_CODE = "isoCountryCode";
    public static final String POSTAL_CODE = "postalCode";
    public static final String PHONE = "phone";
    public static final String MOBILE = "mobile";
    public static final String FAX = "fax";
    public static final String EMAIL = "email";
    public static final String NOTES = "notes";
    public static final String URI = "uri";
    public static final String ID = "Address_edit";

    public SimpleAddressPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public SimpleAddressPropertyForm(ItemSelectionModel itemModel, SimpleAddressPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.address").localize()));
        StringParameter addressBodyParam = new StringParameter(ADDRESS);
        addressBodyParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        addressBodyParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextArea addressBody = new TextArea((ParameterModel)addressBodyParam);
        addressBody.setRows(5);
        addressBody.setCols(30);
        this.add((Component)addressBody);
        if (!SimpleAddress.getConfig().getHideCountryCodeSelection()) {
            this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.iso_country_code").localize()));
            StringParameter isoCountryCodeParam = new StringParameter(ISO_COUNTRY_CODE);
            isoCountryCodeParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 2));
            SingleSelect isoCountryCode = new SingleSelect((ParameterModel)isoCountryCodeParam);
            isoCountryCode.addOption(new Option("", (Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.ui.select_one").localize())));
            DomainCollection countries = IsoCountry.retrieveAll();
            while (countries.next()) {
                IsoCountry country = (IsoCountry)countries.getDomainObject();
                isoCountryCode.addOption(new Option(country.getIsoCode(), country.getCountryName()));
            }
            isoCountryCode.addValidationListener(new ParameterListener(){

                public void validate(ParameterEvent e) throws FormProcessException {
                    ParameterData data = e.getParameterData();
                    String isoCode = (String)data.getValue();
                    s_log.debug((Object)("ISO code is : " + isoCode));
                    if (isoCode == null || isoCode.length() == 0) {
                        data.addError((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.error_iso_country").localize());
                    }
                }
            });
            this.add((Component)isoCountryCode);
        }
        if (!SimpleAddress.getConfig().getHidePostalCode()) {
            this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.postal_code").localize()));
            StringParameter postalCodeParam = new StringParameter(POSTAL_CODE);
            postalCodeParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 20));
            TextField postalCode = new TextField((ParameterModel)postalCodeParam);
            postalCode.setMaxLength(20);
            this.add((Component)postalCode);
        }
        this.add((Component)new Label(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.phone")));
        StringParameter phoneParam = new StringParameter(PHONE);
        phoneParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 20));
        TextField phone = new TextField((ParameterModel)phoneParam);
        phone.setSize(20);
        phone.setMaxLength(20);
        this.add((Component)phone);
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.mobile").localize()));
        StringParameter mobileParam = new StringParameter(MOBILE);
        mobileParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 20));
        TextField mobile = new TextField((ParameterModel)mobileParam);
        mobile.setSize(20);
        mobile.setMaxLength(20);
        this.add((Component)mobile);
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.fax").localize()));
        StringParameter faxParam = new StringParameter(FAX);
        faxParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 20));
        TextField fax = new TextField((ParameterModel)faxParam);
        fax.setSize(20);
        fax.setMaxLength(20);
        this.add((Component)fax);
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.email").localize()));
        StringParameter emailParam = new StringParameter(EMAIL);
        emailParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 75));
        TextField email = new TextField((ParameterModel)emailParam);
        email.setSize(25);
        email.setMaxLength(75);
        email.setHint(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.email_hint").localize().toString());
        this.add((Component)email);
        this.add((Component)new Label(""));
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.email_desc").localize()));
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.uri").localize()));
        StringParameter uriParam = new StringParameter(URI);
        uriParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 250));
        TextField uri = new TextField((ParameterModel)uriParam);
        uri.addValidationListener((ParameterListener)new URLValidationListener(){

            public void validate(ParameterEvent e) throws FormProcessException {
                ParameterData d = e.getParameterData();
                String value = (String)d.getValue();
                if (value.indexOf("http") < 0) {
                    value = "http://" + value;
                }
                d.setValue((Object)value);
                super.validate(e);
            }
        });
        uri.setSize(30);
        uri.setMaxLength(250);
        uri.setHint(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.uri_hint").localize().toString());
        this.add((Component)uri);
        this.add((Component)new Label(""));
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.uri_desc").localize()));
        this.add((Component)new Label((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.notes").localize()));
        StringParameter notesParam = new StringParameter(NOTES);
        TextArea notes = new TextArea((ParameterModel)notesParam);
        notes.setRows(8);
        notes.setCols(30);
        this.add((Component)notes);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        SimpleAddress address = (SimpleAddress)super.initBasicWidgets(fse);
        String uri = address.getURI();
        if (uri != null) {
            if (uri.toLowerCase().indexOf("http") < 0) {
                address.setURI("http://" + uri);
            }
        } else {
            address.setURI("http://");
        }
        data.put((Object)ADDRESS, (Object)address.getAddress());
        if (!SimpleAddress.getConfig().getHideCountryCodeSelection()) {
            data.put((Object)ISO_COUNTRY_CODE, (Object)address.getCountryIsoCode());
        }
        if (!SimpleAddress.getConfig().getHidePostalCode()) {
            data.put((Object)POSTAL_CODE, (Object)address.getPostalCode());
        }
        data.put((Object)PHONE, (Object)address.getPhone());
        data.put((Object)MOBILE, (Object)address.getMobile());
        data.put((Object)FAX, (Object)address.getFax());
        data.put((Object)EMAIL, (Object)address.getEmail());
        data.put((Object)URI, (Object)address.getURI());
        data.put((Object)NOTES, (Object)address.getNotes());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        SimpleAddress address = (SimpleAddress)super.processBasicWidgets(fse);
        if (address != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            address.setAddress((String)data.get((Object)ADDRESS));
            if (!SimpleAddress.getConfig().getHideCountryCodeSelection()) {
                address.setCountryIsoCode((String)data.get((Object)ISO_COUNTRY_CODE));
            }
            address.setPostalCode(!SimpleAddress.getConfig().getHidePostalCode() ? (String)data.get((Object)POSTAL_CODE) : "");
            address.setPhone((String)data.get((Object)PHONE));
            address.setMobile((String)data.get((Object)MOBILE));
            address.setFax((String)data.get((Object)FAX));
            address.setEmail((String)data.get((Object)EMAIL));
            address.setURI((String)data.get((Object)URI));
            address.setNotes((String)data.get((Object)NOTES));
            address.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

