/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.PageState;
import com.arsdigita.categorization.CategorizedObject;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleService;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.ExpirationListener;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.forum.PostImageAttachment;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Post
extends ThreadedMessage {
    private static final Logger s_log = Logger.getLogger(Post.class);
    public static final String STATUS = "status";
    public static final String MODERATOR = "moderator";
    public static final String IMAGE_ATTACHMENTS = "images";
    public static final String FILE_ATTACHMENTS = "files";
    public static final String PENDING = "pending";
    public static final String APPROVED = "approved";
    public static final String REJECTED = "rejected";
    public static final String REAPPROVE = "reapprove";
    public static final String SUPPRESSED = "suppressed";
    public static final String POST_STATUS_SUBQUERY = "com.arsdigita.forum.threadModerationStatus";
    private Party m_moderator;
    private boolean m_wasNew;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.Post";

    private Post() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Post(String typeName) {
        super(typeName);
    }

    public Post(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Post(BigDecimal id) {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Post(DataObject obj) {
        super(obj);
    }

    public static Post create(Forum forum) {
        Post post = new Post();
        post.setForum(forum);
        return post;
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ThreadedMessage newInstance() {
        return Post.create(this.getForum());
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        Forum forum = this.getForum();
        Assert.exists((Object)((Object)forum), Forum.class);
        BigDecimal id = this.getID();
        this.setRFCMessageID(id + ".bboard@" + Forum.getConfig().getReplyHostName());
        this.setReplyTo(this.getRefersTo() + ".bboard@" + Forum.getConfig().getReplyHostName());
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        Forum forum = this.getForum();
        MessageThread root = this.getThread();
        Assert.exists((Object)root);
        s_log.info((Object)("Setting context for " + this.getOID() + " to " + root.getOID()));
        PermissionService.setContext((ACSObject)this, (ACSObject)root);
        s_log.info((Object)("Setting context for " + root.getOID() + " to " + forum.getOID()));
        PermissionService.setContext((ACSObject)root, (ACSObject)forum);
        if (this.m_wasNew && this.getRoot() == null && forum.getExpireAfter() > 0) {
            s_log.info((Object)("Creating expiration lifecycle for " + this.getOID()));
            this.setLifecycle(forum.getLifecycleDefinition());
        }
        this.m_wasNew = false;
        DataAssociationCursor files = this.getFiles();
        while (files.next()) {
            PostFileAttachment file = (PostFileAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
            if (this.getStatus().equals(APPROVED)) {
                file.setLive();
                continue;
            }
            file.setDraft();
        }
    }

    public void sendNotifications(final String context) {
        KernelExcursion ex = new KernelExcursion(){

            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Post.this.doSendNotifications(context);
            }
        };
        ex.run();
    }

    public void sendModeratorAlerts() {
        if (!this.getStatus().equals(APPROVED)) {
            KernelExcursion ex = new KernelExcursion(){

                protected void excurse() {
                    this.setEffectiveParty(Kernel.getSystemParty());
                    Post.this.doSendModeratorAlerts();
                }
            };
            ex.run();
        } else {
            s_log.debug((Object)"not sending moderator alerts because the post was pre-approved (created by an approver)");
        }
    }

    private void doSendNotifications(String context) {
        s_log.debug((Object)"sending user notifications");
        Forum forum = this.getForum();
        if (this.getStatus().equals(APPROVED)) {
            s_log.debug((Object)"Sending forum level subsriptions");
            DataCollection subscriptions = forum.getSubscriptions();
            while (subscriptions.next()) {
                ForumSubscription subscription = (ForumSubscription)DomainObjectFactory.newInstance((DataObject)subscriptions.getDataObject());
                s_log.debug((Object)("notification to  " + subscription.getOID()));
                subscription.sendNotification(this, Forum.getConfig().deleteNotifications());
            }
            s_log.debug((Object)"Sending thread level subsriptions");
            if (context == null || !context.equals("new")) {
                ThreadSubscription sub = ThreadSubscription.getThreadSubscription(this.getThread());
                if (sub == null) {
                    s_log.error((Object)("Got a null ThreadSubscription from Post # " + this.getID()));
                } else {
                    sub.sendNotification(this, Forum.getConfig().deleteNotifications());
                }
            }
        } else {
            s_log.debug((Object)"Not sending notifications because the message is not approved");
        }
    }

    private void doSendModeratorAlerts() {
        Forum forum;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"sending moderator notice");
        }
        if ((forum = this.getForum()).isModerated()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Processing moderation alerts");
            }
            DataCollection alerts = forum.getModerationAlerts();
            while (alerts.next()) {
                ModerationAlert alert = (ModerationAlert)DomainObjectFactory.newInstance((DataObject)alerts.getDataObject());
                s_log.debug((Object)("Processing moderation alert " + alert.getOID()));
                alert.sendNotification(this, Forum.getConfig().deleteNotifications());
            }
        } else {
            s_log.debug((Object)"Not sending moderator alerts because the forum is not moderated");
        }
    }

    public void setForum(Forum forum) {
        this.setRefersTo((ACSObject)forum);
    }

    public Forum getForum() {
        BigDecimal id = this.getRefersTo();
        Assert.exists((Object)id, BigDecimal.class);
        return new Forum(id);
    }

    public void mapCategory(Category category) throws PersistenceException {
        if (this.isNew()) {
            throw new PersistenceException("Post must be persistent to map categories");
        }
        category.addChild((ACSObject)this);
        category.save();
    }

    public void clearCategories() {
        DataCollection categories = SessionManager.getSession().retrieve("com.arsdigita.categorization.Category");
        categories.addEqualsFilter("childObjects.id", (Object)this.getID());
        while (categories.next()) {
            Category cat = (Category)DomainObjectFactory.newInstance((DataObject)categories.getDataObject());
            cat.removeChild((ACSObject)this);
        }
    }

    public CategoryCollection getCategories() {
        return new CategorizedObject((ACSObject)this).getParents();
    }

    public ThreadSubscription createThreadSubscription() {
        ThreadSubscription sub = null;
        if (this.getRoot() == null) {
            sub = new ThreadSubscription();
            sub.setThread(this.getThread());
            sub.save();
        }
        return sub;
    }

    public ThreadSubscription getSubscription() {
        MessageThread thread = this.getRoot() != null ? this.getRootMsg().getThread() : this.getThread();
        DataCollection subscriptions = SessionManager.getSession().retrieve("com.arsdigita.forum.ThreadSubscription");
        subscriptions.addEqualsFilter("thread", (Object)thread.getID());
        ThreadSubscription subscription = null;
        while (subscriptions.next()) {
            subscription = (ThreadSubscription)DomainObjectFactory.newInstance((DataObject)subscriptions.getDataObject());
        }
        return subscription;
    }

    public boolean canEdit(Party party) {
        Party author = this.getFrom();
        return !author.equals((Object)Kernel.getPublicUser()) && Forum.getConfig().canAuthorEditPosts() && author.equals((Object)party) || this.getForum().canEdit(party);
    }

    public boolean canDelete(Party party) {
        Party author = this.getFrom();
        return !author.equals((Object)Kernel.getPublicUser()) && Forum.getConfig().canAuthorDeletePosts() && author.equals((Object)party) || this.getForum().canDelete(party);
    }

    public void setStatus(String status) {
        Assert.isTrue((status.equals(APPROVED) || status.equals(REJECTED) || status.equals(REAPPROVE) || status.equals(SUPPRESSED) || status.equals(PENDING) ? 1 : 0) != 0, (String)("The status must be one of approved, rejected, reapprove, suppressed, the input was " + status));
        this.set(STATUS, status);
    }

    public void setStatus(PageState state) {
        this.setStatus(state, null);
    }

    public void setStatus(PageState state, String previousStatus) {
        ForumContext ctx = ForumContext.getContext(state);
        Forum forum = ctx.getForum();
        if (forum.isModerated() && !ctx.canModerate()) {
            if (APPROVED.equals(previousStatus)) {
                this.setStatus(REAPPROVE);
            } else {
                this.setStatus(PENDING);
            }
        } else {
            this.setStatus(APPROVED);
        }
    }

    public String getStatus() {
        return (String)this.get(STATUS);
    }

    public void setModerator(Party moderator) {
        this.setAssociation(MODERATOR, (DomainObject)moderator);
    }

    public Party getModerator() {
        DataObject moderatorData;
        if (this.m_moderator == null && (moderatorData = (DataObject)this.get(MODERATOR)) != null) {
            this.m_moderator = (Party)DomainObjectFactory.newInstance((DataObject)moderatorData);
        }
        return this.m_moderator;
    }

    protected void beforeDelete() {
        s_log.debug((Object)("Post - before delete " + this.getID()));
        super.beforeDelete();
        DataCollection requests = SessionManager.getSession().retrieve(Notification.BASE_DATA_OBJECT_TYPE);
        requests.addEqualsFilter("messageID", (Object)this.getID());
        while (requests.next()) {
            Notification no = new Notification(requests.getDataObject().getOID());
            no.setMessageDelete(Boolean.FALSE);
            no.delete();
        }
        if (this.getRoot() == null) {
            s_log.debug((Object)"Root post - get rid of thread subscription and thread");
            MessageThread thread = this.getThread();
            ThreadSubscription sub = ThreadSubscription.getThreadSubscription(thread);
            if (sub != null) {
                sub.delete();
            }
            if (thread != null) {
                thread.delete();
            }
        }
    }

    void setLifecycle(LifecycleDefinition life) {
        Lifecycle cycle = life.createFullLifecycle(this.getSentDate(), ExpirationListener.class.getName());
        LifecycleService.setLifecycle((ACSObject)this, (Lifecycle)cycle);
        cycle.start();
        cycle.save();
    }

    public void addImage(PostImageAttachment image) {
        DataAssociation images = (DataAssociation)this.get(IMAGE_ATTACHMENTS);
        image.addToAssociation(images);
        long currentImageCount = images.getDataAssociationCursor().size();
        image.setImageOrder((int)currentImageCount);
    }

    public void removeImage(PostImageAttachment image) {
        DataAssociation images = (DataAssociation)this.get(IMAGE_ATTACHMENTS);
        image.removeFromAssociation(images);
        this.renumberImages();
    }

    private void renumberImages() {
        int count = 1;
        DataAssociationCursor images = this.getImages();
        while (images.next()) {
            PostImageAttachment image = (PostImageAttachment)DomainObjectFactory.newInstance((DataObject)images.getDataObject());
            image.setImageOrder(count);
            ++count;
        }
    }

    public DataAssociationCursor getImages() {
        DataAssociationCursor images = ((DataAssociation)this.get(IMAGE_ATTACHMENTS)).getDataAssociationCursor();
        images.addOrder("imageOrder");
        return images;
    }

    public void addFile(PostFileAttachment file) {
        DataAssociation files = (DataAssociation)this.get(FILE_ATTACHMENTS);
        file.addToAssociation(files);
        PermissionService.setContext((ACSObject)file, (ACSObject)this);
        long currentFileCount = files.getDataAssociationCursor().size();
        file.setFileOrder((int)currentFileCount);
    }

    public void removeFile(PostFileAttachment file) {
        DataAssociation files = (DataAssociation)this.get(FILE_ATTACHMENTS);
        file.removeFromAssociation(files);
        this.renumberFiles();
    }

    private void renumberFiles() {
        int count = 1;
        DataAssociationCursor files = this.getFiles();
        while (files.next()) {
            PostFileAttachment file = (PostFileAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
            file.setFileOrder(count);
            ++count;
        }
    }

    public DataAssociationCursor getFiles() {
        DataAssociationCursor files = ((DataAssociation)this.get(FILE_ATTACHMENTS)).getDataAssociationCursor();
        files.addOrder("fileOrder");
        return files;
    }

    protected void addReplyFilter(DataCollection replies) {
        replies.addEqualsFilter(STATUS, (Object)APPROVED);
    }
}

