/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.forum.Post;
import com.arsdigita.mail.Mail;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.BaseSubscription;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public abstract class Subscription
extends BaseSubscription {
    private static final Logger s_log = Logger.getLogger(Subscription.class);
    protected static final String HTML_SEPARATOR = "<br><br>\n<hr>\n<br><br>\n";

    public Subscription(String objectType) {
        super(objectType);
    }

    public Subscription(DataObject dataObj) {
        super(dataObj);
    }

    public Subscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getHeader(ThreadedMessage msg) {
        Assert.isTrue((boolean)(msg instanceof Post), (String)"Parameter msg should be a Post");
        Post post = (Post)msg;
        String author = post.getFrom().getName();
        if (author == null) {
            author = "Unknown";
        }
        StringBuffer sb = new StringBuffer();
        if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
            sb.append("<font size='medium' face='Verdana, Arial, Helvetica, sans-serif'>");
            sb.append("Forum    : ");
            sb.append(post.getForum().getDisplayName()).append("\n<br>");
            sb.append("Subject  : ");
            sb.append(post.getSubject()).append("\n<br>");
            sb.append("Posted by: ");
            sb.append(author).append("\n<br><br>");
        } else {
            sb.append("Forum    : ");
            sb.append(post.getForum().getDisplayName()).append("\n");
            sb.append("Subject  : ");
            sb.append(post.getSubject()).append("\n");
            sb.append("Posted by: ");
            sb.append(author).append("\n\n");
        }
        return sb.toString();
    }

    public String getSignature(ThreadedMessage post) {
        if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
            return "<br><br>\n<hr>\n<br><br>\nThis is an automated alert from the Discussion Forum system. </font>";
        }
        return SEPARATOR + "This is an automated alert from the Discussion Forum system. ";
    }

    protected static String getReturnURLMessage(Post post) {
        ParameterMap params = new ParameterMap();
        params.setParameter("thread", (Object)post.getThread().getID());
        URL url = URL.there((Application)post.getForum(), (String)"/thread.jsp", (ParameterMap)params);
        StringBuffer sb = new StringBuffer();
        sb.append("To reply to this message, go to:\n");
        if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
            sb.append("<br><a href='" + url.getURL() + "'>" + url.getURL() + "</a>");
        } else {
            sb.append(url.getURL());
        }
        return sb.toString();
    }
}

