/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.PageState;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.Subscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.mail.Mail;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class ThreadSubscription
extends Subscription {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ThreadSubscription";
    public static final String THREAD = "thread";
    private MessageThread m_thread = null;

    public ThreadSubscription() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ThreadSubscription(String objectType) {
        super(objectType);
    }

    public ThreadSubscription(DataObject dataObj) {
        super(dataObj);
    }

    public ThreadSubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getSubscriptionGroupName() {
        return super.getSubscriptionGroupName();
    }

    public String getSubscriptionGroupName(Forum forum) {
        return forum.getTitle() + ": " + this.getThreadReal().getRootMessage().getSubject() + " Subscription Group";
    }

    protected Group getParentGroup() {
        GroupCollection forumGroups = ((Forum)Kernel.getContext().getResource()).getGroup().getSubgroups();
        forumGroups.addEqualsFilter("name", (Object)"Thread Subscription Groups");
        Group parent = null;
        if (forumGroups.next()) {
            parent = forumGroups.getGroup();
            forumGroups.close();
        }
        return parent;
    }

    public ThreadSubscription(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Post getThread() {
        return (Post)this.getThreadReal().getRootMessage();
    }

    public MessageThread getThreadReal() {
        DataObject threadData;
        if (this.m_thread == null && (threadData = (DataObject)this.get(THREAD)) != null) {
            this.m_thread = new MessageThread(threadData);
        }
        return this.m_thread;
    }

    public void doWriteCheck() {
        this.getThread().assertPrivilege(PrivilegeDescriptor.READ);
    }

    public void setThread(Post post) {
        this.setThread(post.getThread());
    }

    public void setThread(MessageThread thread) {
        this.m_thread = thread;
        this.setAssociation(THREAD, (DomainObject)thread);
        this.getGroup().setName(this.getSubscriptionGroupName((Forum)Kernel.getContext().getResource()));
    }

    protected void afterSave() {
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getThreadReal());
        PermissionService.setContext((ACSObject)this.getGroup(), (ACSObject)this.getThreadReal());
        super.afterSave();
    }

    protected void beforeDelete() {
        DataCollection notifications = SessionManager.getSession().retrieve(Notification.BASE_DATA_OBJECT_TYPE);
        notifications.addEqualsFilter("partyTo", (Object)this.getGroup().getID());
        while (notifications.next()) {
            Notification no = new Notification(notifications.getDataObject().getOID());
            no.setMessageDelete(Boolean.FALSE);
            no.delete();
        }
        super.beforeDelete();
    }

    public static ThreadSubscription getThreadSubscription(Post post) {
        return ThreadSubscription.getThreadSubscription(post.getThread());
    }

    public static ThreadSubscription getThreadSubscription(MessageThread thread) {
        DataCollection subs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subs.addEqualsFilter("thread.id", (Object)thread.getID());
        ThreadSubscription sub = null;
        if (subs.next()) {
            sub = new ThreadSubscription(subs.getDataObject());
        }
        subs.close();
        return sub;
    }

    public static DomainCollection getSubsForUser(Party party, PageState state) {
        DataCollection subscriptions = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subscriptions.addEqualsFilter("group.allMembers.id", (Object)party.getID());
        if (!Forum.getConfig().showThreadAlertsForAllForums()) {
            subscriptions.addEqualsFilter("thread.root.objectID", (Object)ForumContext.getContext(state).getForum().getID());
        }
        return new DomainCollection(subscriptions);
    }

    @Override
    public String getSignature(ThreadedMessage post) {
        StringBuffer sb = new StringBuffer();
        if (Mail.getConfig().sendHTMLMessageAsHTMLEmail()) {
            sb.append("<br><br>\n<hr>\n<br><br>\n");
            sb.append(ThreadSubscription.getReturnURLMessage((Post)post));
            sb.append("<br><br>\n<hr>\n<br><br>\n");
            sb.append("This is an automated alert from the Discussion Forum system. ");
            sb.append("You are receiving this email because you subscribed to ");
            sb.append("alerts on this thread. To unsubscribe, follow the link above and click the 'stop watching thread' link at the top of the page.\n");
            sb.append("</font>");
        } else {
            sb.append(SEPARATOR);
            sb.append("This is an automated alert from the Discussion Forum system. ");
            sb.append("You are receiving this email because you subscribed to ");
            sb.append("alerts on this thread.\n\n");
            sb.append("Replying to this email will add a post to the forum. It will not send email directly to the person who posted this message.\n\n");
            sb.append(ThreadSubscription.getReturnURLMessage((Post)post));
        }
        return sb.toString();
    }
}

