/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.search;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.search.PostMetadataProvider;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

public class XMLContentProvider
implements ContentProvider,
Constants {
    private static final Logger s_log = Logger.getLogger(XMLContentProvider.class);
    private Post m_post;
    private String m_context;

    public XMLContentProvider(String context, Post post) {
        this.m_context = context;
        this.m_post = post;
    }

    public String getContext() {
        return this.m_context;
    }

    public ContentType getType() {
        return ContentType.XML;
    }

    public byte[] getBytes() {
        Element root = new Element("forum:post", "http://www.arsdigita.com/forum/1.0");
        DomainObjectXMLRenderer renderer = new DomainObjectXMLRenderer(root);
        renderer.setWrapAttributes(true);
        renderer.walk((DomainObject)this.m_post, PostMetadataProvider.class.getName());
        Document doc = null;
        try {
            doc = new Document(root);
        }
        catch (ParserConfigurationException ex) {
            throw new UncheckedWrapperException("Unable to create xml document for post " + this.m_post.getID(), (Throwable)ex);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("XML is " + doc.toString(true)));
        }
        String xml = doc.toString(true);
        return xml.getBytes();
    }
}

