/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.Text;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SetupView
extends Form
implements FormInitListener,
FormSubmissionListener,
FormProcessListener,
Constants {
    private static final Logger s_log = Logger.getLogger(SetupView.class);
    private static final String MODERATED = "moderated";
    private static final String PUBLIC = "public";
    private static final String NOTICEBOARD = "noticeboard";
    private static final String ALLOW_FILES = "filesAllowed";
    private static final String ALLOW_IMAGES = "imagesallowed";
    private static final String AUTOSUBSCRIBE_THREAD_STARTERS = "autosubscribe";
    private static final String NO_CATEGORY_POSTS_ALLOWED = "nocategory";
    private static final String ANONYMOUS_POSTS_ALLOWED = "anonymous";
    private CheckboxGroup m_settings = new CheckboxGroup("settings");
    private TextField m_expiry;
    private SaveCancelSection m_saveCancel;
    private TextArea m_introduction;
    private TextField m_title;

    public SetupView() {
        super("setupForm", (Container)new SimpleContainer("forum:setup", "http://www.arsdigita.com/forum/1.0"));
        this.m_settings.addOption(new Option(MODERATED, (String)Text.gz("forum.ui.settings.moderated").localize()));
        this.m_settings.addOption(new Option(PUBLIC, (String)Text.gz("forum.ui.settings.public").localize()));
        this.m_settings.addOption(new Option(NOTICEBOARD, (String)Text.gz("forum.ui.settings.noticeboard").localize()));
        this.m_settings.addOption(new Option(ALLOW_FILES, (String)Text.gz("forum.ui.settings.allowFiles").localize()));
        this.m_settings.addOption(new Option(ALLOW_IMAGES, (String)Text.gz("forum.ui.settings.allowImages").localize()));
        this.m_settings.addOption(new Option(AUTOSUBSCRIBE_THREAD_STARTERS, (String)Text.gz("forum.ui.settings.autosubscribe").localize()));
        this.m_settings.addOption(new Option(NO_CATEGORY_POSTS_ALLOWED, (String)Text.gz("forum.ui.settings.noCategoryPosts").localize()));
        this.m_settings.addOption(new Option(ANONYMOUS_POSTS_ALLOWED, (String)Text.gz("forum.ui.settings.anonymousPosts").localize()));
        this.m_expiry = new TextField((ParameterModel)new IntegerParameter("expiry"));
        this.m_expiry.setMetaDataAttribute("label", (String)Text.gz("forum.ui.noticeboard.expiry_after").localize());
        this.m_saveCancel = new SaveCancelSection();
        this.m_saveCancel.getSaveButton().setButtonLabel(Text.gz("forum.ui.settings.save"));
        this.m_introduction = new TextArea("introduction", 8, 60, 2);
        this.m_introduction.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, 4000, Text.gz("forum.ui.validation.introduction_too_long")));
        this.m_introduction.setMetaDataAttribute("label", (String)Text.gz("forum.ui.settings.introduction").localize());
        this.m_title = new TextField("title");
        this.m_title.setMetaDataAttribute("label", (String)Text.gz("forum.ui.settings.title").localize());
        this.m_title.setSize(70);
        this.add((Component)this.m_title);
        this.add((Component)this.m_introduction);
        this.add((Component)this.m_settings);
        this.add((Component)this.m_expiry);
        this.add((Component)this.m_saveCancel);
        this.addInitListener(this);
        this.addSubmissionListener(this);
        this.addProcessListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        Forum forum = ForumContext.getContext(state).getForum();
        HashSet<String> settingsSet = new HashSet<String>();
        if (forum.isModerated()) {
            settingsSet.add(MODERATED);
        }
        if (forum.isNoticeboard()) {
            settingsSet.add(NOTICEBOARD);
        }
        if (forum.allowFileAttachments()) {
            settingsSet.add(ALLOW_FILES);
        }
        if (forum.allowImageUploads()) {
            settingsSet.add(ALLOW_IMAGES);
        }
        if (forum.autoSubscribeThreadStarter()) {
            settingsSet.add(AUTOSUBSCRIBE_THREAD_STARTERS);
        }
        if (forum.noCategoryPostsAllowed()) {
            settingsSet.add(NO_CATEGORY_POSTS_ALLOWED);
        }
        if (forum.anonymousPostsAllowed()) {
            settingsSet.add(ANONYMOUS_POSTS_ALLOWED);
        }
        this.m_settings.setValue(state, (Object)settingsSet.toArray());
        this.m_expiry.setValue(state, (Object)new Integer(forum.getExpireAfter()));
        this.m_introduction.setValue(state, (Object)forum.getIntroduction());
        this.m_title.setValue(state, (Object)forum.getTitle());
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (this.m_saveCancel.getCancelButton().isSelected(state)) {
            s_log.debug((Object)"cancelled");
            throw new FormProcessException("cancelled");
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        Forum forum = ForumContext.getContext(state).getForum();
        String[] settingsArray = (String[])this.m_settings.getValue(state);
        List<String> settings = Collections.EMPTY_LIST;
        if (settingsArray != null) {
            settings = Arrays.asList(settingsArray);
        }
        forum.setModerated(settings.contains(MODERATED));
        forum.setPublic(settings.contains(PUBLIC));
        forum.setNoticeboard(settings.contains(NOTICEBOARD));
        forum.setAllowFileAttachments(settings.contains(ALLOW_FILES));
        forum.setAllowImageUploads(settings.contains(ALLOW_IMAGES));
        forum.setAutoSubscribeThreadCreator(settings.contains(AUTOSUBSCRIBE_THREAD_STARTERS));
        forum.setNoCategoryPostsAllowed(settings.contains(NO_CATEGORY_POSTS_ALLOWED));
        forum.setAnonymousPostsAllowed(settings.contains(ANONYMOUS_POSTS_ALLOWED));
        forum.setTitle((String)this.m_title.getValue(state));
        forum.setIntroduction((String)this.m_introduction.getValue(state));
        Integer expiry = this.m_expiry.getValue(state) == null ? new Integer(0) : (Integer)this.m_expiry.getValue(state);
        int newExpiry = expiry;
        if (forum.getExpireAfter() != newExpiry) {
            forum.setExpireAfter(newExpiry);
        }
    }
}

