/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.SiteProxy;
import com.arsdigita.cms.contenttypes.util.SiteProxyGlobalizationUtil;
import com.arsdigita.util.url.URLCache;
import com.arsdigita.util.url.URLData;
import com.arsdigita.util.url.URLFetcher;
import com.arsdigita.util.url.URLPool;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SiteProxyExtraXMLGenerator
implements ExtraXMLGenerator {
    private static final Logger logger = Logger.getLogger(SiteProxyExtraXMLGenerator.class);
    private static final String SITE_PROXY_PANEL_NAME = "cms:siteProxyPanel";
    private static final String DATA_TYPE = "dataType";
    private static final String C_DATA_DATA_TYPE = "cdata";
    private static final String XML_DATA_TYPE = "xml";
    private static final String s_cacheServiceKey = "SiteProxyPanel";
    private static final URLCache s_cache = new URLCache(1000000L, 60000L);
    private static final URLPool s_pool = new URLPool();

    public void generateXML(ContentItem item, Element element, PageState state) {
        if (!(item instanceof SiteProxy)) {
            throw new IllegalArgumentException("Only SiteProxy items are supported");
        }
        SiteProxy siteProxy = (SiteProxy)item;
        String url = this.passParameters(state.getRequest(), siteProxy.getURL());
        Element child = element.newChildElement(SITE_PROXY_PANEL_NAME, "http://www.arsdigita.com/cms/1.0");
        URLData data = this.getRemoteXML(child, url);
        if (data == null) {
            Object[] urlArray = new String[]{url};
            Element error = child.newChildElement("siteProxyError");
            error.setText((String)SiteProxyGlobalizationUtil.globalize("cms.contenttypes.siteproxy.error_fetching_url", urlArray).localize());
        } else if (data.getException() != null) {
            Object[] urlArray = new String[]{url, data.getException().getClass().getName(), data.getException().getMessage()};
            Element error = child.newChildElement("siteProxyError");
            error.setText((String)SiteProxyGlobalizationUtil.globalize("cms.contenttypes.siteproxy.exception_fetching_url", urlArray).localize());
        } else if (data.getContent().length == 0) {
            Object[] urlArray = new String[]{url};
            Element error = child.newChildElement("siteProxyError");
            error.setText((String)SiteProxyGlobalizationUtil.globalize("cms.contenttypes.siteproxy.empty_page_returned", urlArray).localize());
        }
    }

    public void addGlobalStateParams(Page page) {
    }

    public void setListMode(boolean listMode) {
    }

    private String passParameters(HttpServletRequest request, String url) {
        StringBuilder sb = new StringBuilder(url);
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            for (int i = 0; i < paramValues.length; ++i) {
                if (sb.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(paramName).append("=");
                try {
                    sb.append(URLEncoder.encode(paramValues[i], enc));
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    logger.error((Object)"Unable to encode SiteProxy request", (Throwable)ex);
                    return url;
                }
            }
        }
        return sb.toString();
    }

    public URLData getRemoteXML(Element child, String url) {
        URLData data = URLFetcher.fetchURLData((String)url, (String)s_cacheServiceKey);
        if (data == null || data.getException() != null || data.getContent().length == 0) {
            return data;
        }
        String contentType = data.getContentType();
        boolean success = false;
        if (contentType != null && contentType.toLowerCase().indexOf("/xml") > -1) {
            Document document = null;
            try {
                document = new Document(data.getContent());
                success = true;
            }
            catch (Exception ex) {
                logger.info((Object)("The document is not proper XML, trying to add the property xml headers to the file retrieved from " + url), (Throwable)ex);
                try {
                    byte[] xml = data.getContent();
                    String xmlString = String.format("<?xml version=\"1.0\"?> \n%s", new String(xml, Charset.forName("UTF-8")));
                    document = new Document(xmlString);
                    success = true;
                    logger.info((Object)("Adding the headers to " + url + " allowed it to be properly parsed."));
                }
                catch (Exception exception) {
                    logger.info((Object)("The document found at " + url + " is not correctly formed XML"), (Throwable)exception);
                }
            }
            if (success) {
                child.addContent(document.getRootElement());
                child.addAttribute(DATA_TYPE, XML_DATA_TYPE);
            }
        }
        if (!success) {
            child.setCDATASection(new String(data.getContent(), Charset.forName("UTF-8")));
            child.addAttribute(DATA_TYPE, C_DATA_DATA_TYPE);
        }
        return data;
    }

    static {
        logger.debug((Object)"Static initalizer starting...");
        URLFetcher.registerService((String)s_cacheServiceKey, (URLPool)s_pool, (URLCache)s_cache);
        logger.debug((Object)"Static initalizer finished.");
    }
}

