/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http.ui;

import com.arsdigita.auth.http.UserLogin;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

class UserForm
extends Form
implements FormProcessListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger(UserForm.class);
    protected final String FIRST_NAME = "firstName";
    protected final String LAST_NAME = "lastName";
    protected final String EMAIL = "email";
    protected final String NT_USER = "ntUser";
    protected TextField m_firstName;
    protected TextField m_lastName;
    protected TextField m_email;
    protected TextField m_ntUser;
    protected Submit m_save;
    protected RequestLocal m_user;

    public UserForm(RequestLocal user) {
        super("userForm");
        this.m_user = user;
        this.m_firstName = new TextField("firstName");
        this.m_lastName = new TextField("lastName");
        this.m_email = new TextField((ParameterModel)new EmailParameter("email"));
        this.m_ntUser = new TextField("ntUser");
        this.m_save = new Submit("Save");
        NotEmptyValidationListener notEmpty = new NotEmptyValidationListener();
        this.m_firstName.addValidationListener((ParameterListener)notEmpty);
        this.m_lastName.addValidationListener((ParameterListener)notEmpty);
        this.m_email.addValidationListener((ParameterListener)notEmpty);
        this.m_ntUser.addValidationListener((ParameterListener)notEmpty);
        this.add((Component)new Label("First Name"));
        this.add((Component)this.m_firstName);
        this.add((Component)new Label("Last Name"));
        this.add((Component)this.m_lastName);
        this.add((Component)new Label("Email address"));
        this.add((Component)this.m_email);
        this.add((Component)new Label("Windows NT user account"));
        this.add((Component)this.m_ntUser);
        this.add((Component)this.m_save);
        this.addProcessListener(this);
        this.addInitListener(this);
    }

    public void init(FormSectionEvent e) {
        PageState ps = e.getPageState();
        FormData data = e.getFormData();
        User user = (User)this.m_user.get(ps);
        if (user == null) {
            return;
        }
        UserLogin login = UserLogin.findByUser(user);
        PersonName name = user.getPersonName();
        data.put((Object)"firstName", (Object)name.getGivenName());
        data.put((Object)"lastName", (Object)name.getFamilyName());
        data.put((Object)"email", (Object)user.getPrimaryEmail());
        data.put((Object)"ntUser", (Object)(login == null ? null : login.getLogin()));
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState ps = e.getPageState();
        FormData data = e.getFormData();
        boolean newUser = false;
        User user = (User)this.m_user.get(ps);
        if (user == null) {
            user = new User();
            newUser = true;
        }
        UserLogin login = UserLogin.findByUser(user);
        EmailAddress email = new EmailAddress(((InternetAddress)this.m_email.getValue(ps)).getAddress());
        s_log.debug((Object)("email = " + user.getPrimaryEmail()));
        s_log.debug((Object)("new email = " + email));
        if (user.getPrimaryEmail() == null || !user.getPrimaryEmail().equals((Object)email)) {
            user.setPrimaryEmail(email);
        }
        PersonName name = user.getPersonName();
        name.setGivenName(this.m_firstName.getValue(ps).toString());
        name.setFamilyName(this.m_lastName.getValue(ps).toString());
        String ident = this.m_ntUser.getValue(ps).toString();
        if (login == null) {
            login = UserLogin.create(user, ident);
        } else {
            login.setLogin(ident);
        }
        if (newUser) {
            UserAuthentication auth = UserAuthentication.createForUser((User)user);
            auth.setPassword("camden");
            auth.setPasswordQuestion("camden");
            auth.setPasswordAnswer("camden");
            auth.save();
        }
        data.put((Object)"firstName", null);
        data.put((Object)"lastName", null);
        data.put((Object)"email", null);
        data.put((Object)"ntUser", null);
    }
}

