/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Minutes;
import com.arsdigita.cms.contenttypes.ui.MinutesPropertiesStep;
import com.arsdigita.cms.contenttypes.util.MinutesGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;

public class MinutesPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private MinutesPropertiesStep m_step;
    public static final String MINUTE_NUMBER = "minute_number";
    public static final String DESCRIPTION_OF_MINUTES = "descriptionOfMinutes";
    public static final String ACTION_ITEM = "actionItem";
    public static final String ATTENDEES = "attendees";
    public static final String DESCRIPTION = "description";
    public static final String ID = "minutes_edit";

    public MinutesPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public MinutesPropertyForm(ItemSelectionModel itemModel, MinutesPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(MinutesGlobalizationUtil.globalize("cms.contenttypes.ui.minutes.reference")));
        StringParameter minuteNumberParam = new StringParameter(MINUTE_NUMBER);
        TextArea minuteNumber = new TextArea((ParameterModel)minuteNumberParam);
        minuteNumber.setCols(40);
        minuteNumber.setRows(3);
        this.add((Component)minuteNumber);
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description")));
        StringParameter descriptionParam = new StringParameter(DESCRIPTION);
        TextArea description = new TextArea((ParameterModel)descriptionParam);
        description.setCols(40);
        description.setRows(5);
        this.add((Component)description);
        this.add((Component)new Label(MinutesGlobalizationUtil.globalize("cms.contenttypes.ui.minutes.action_item")));
        StringParameter actionItemParam = new StringParameter(ACTION_ITEM);
        TextArea actionItem = new TextArea((ParameterModel)actionItemParam);
        actionItem.setCols(40);
        actionItem.setRows(3);
        this.add((Component)actionItem);
        this.add((Component)new Label(MinutesGlobalizationUtil.globalize("cms.contenttypes.ui.minutes.attendees")));
        StringParameter attendeesParam = new StringParameter(ATTENDEES);
        TextArea attendees = new TextArea((ParameterModel)attendeesParam);
        attendees.setCols(40);
        attendees.setRows(3);
        this.add((Component)attendees);
        this.add((Component)new Label(MinutesGlobalizationUtil.globalize("cms.contenttypes.ui.minutes.description_of")));
        StringParameter descriptionOfMinutesParam = new StringParameter(DESCRIPTION_OF_MINUTES);
        TextArea descriptionOfMinutes = new TextArea((ParameterModel)descriptionOfMinutesParam);
        descriptionOfMinutes.setCols(40);
        descriptionOfMinutes.setRows(5);
        this.add((Component)descriptionOfMinutes);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Minutes minutes = (Minutes)super.initBasicWidgets(fse);
        data.put((Object)ACTION_ITEM, (Object)minutes.getActionItem());
        data.put((Object)ATTENDEES, (Object)minutes.getAttendees());
        data.put((Object)DESCRIPTION, (Object)minutes.getDescription());
        data.put((Object)DESCRIPTION_OF_MINUTES, (Object)minutes.getDescriptionOfMinutes());
        data.put((Object)MINUTE_NUMBER, (Object)minutes.getMinuteNumber());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        Minutes minutes = (Minutes)super.processBasicWidgets(fse);
        if (minutes != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            minutes.setMinuteNumber((String)data.get((Object)MINUTE_NUMBER));
            minutes.setActionItem((String)data.get((Object)ACTION_ITEM));
            minutes.setAttendees((String)data.get((Object)ATTENDEES));
            minutes.setDescription((String)data.get((Object)DESCRIPTION));
            minutes.setDescriptionOfMinutes((String)data.get((Object)DESCRIPTION_OF_MINUTES));
            minutes.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

